<?php

namespace AutoCraftPlayer\App\Helpers;

class PlayerControls
{
    protected $customControls;

    public function __construct()
    {
        $this->customControls = new CustomControls();
    }

    public function getAllControlBarConfig()
    {
        return [
            'children'               => $this->getChildrenConfig(),
            'skipButtons'            => $this->getSkipButtonsConfig(),

            // Control Bar
            'playToggle'             => $this->getPlayToggleConfig(),
            'volumePanel'            => $this->getVolumePanelConfig(),
            'skipBackward'           => $this->getSkipBackwardConfig(),
            'skipForward'            => $this->getSkipForwardConfig(),
            'progressControl'        => $this->getProgressControlConfig(),
            'remainingTimeDisplay'   => $this->getRemainingTimeDisplayConfig(),
            'pictureInPictureToggle' => $this->getPictureInPictureToggleConfig(),
            'playbackRateMenuButton' => $this->getPlaybackRateMenuButtonConfig(),
            'fullscreenToggle'       => $this->getFullscreenToggleConfig(),
            'totalDuration'          => $this->customControls->getTotalDurationConfig(11),
            'titleTrac'              => $this->customControls->getTitleTrackConfig(12),
        ];
    }

    public function getVideoControlBarConfig()
    {
        return $this->getAllControlBarConfig();
    }

    public function getAudioControlBarConfig()
    {
        return [
            'children'               => $this->getChildrenConfig(),
            'skipButtons'            => $this->getSkipButtonsConfig(),

            // Control Bar
            'playToggle'             => $this->getPlayToggleConfig(),
            'volumePanel'            => $this->getVolumePanelConfig(),
            'skipBackward'           => $this->getSkipBackwardConfig(),
            'skipForward'            => $this->getSkipForwardConfig(),
            'progressControl'        => $this->getProgressControlConfig(),
            'remainingTimeDisplay'   => $this->getRemainingTimeDisplayConfig(),
            'playbackRateMenuButton' => $this->getPlaybackRateMenuButtonConfig(),
            'totalDuration'          => $this->customControls->getTotalDurationConfig(9),
            'titleTrac'              => $this->customControls->getTitleTrackConfig(10),
        ];
    }

    public function getSkipButtonsConfig()
    {
        return [
            'forward'  => 10,
            'backward' => 10
        ];
    }

    public function getPlayToggleConfig($position = 1)
    {
        return [
            'id'          => 'playToggle',
            'position'    => $position,
            'title'       => 'Play/Pause',
            'iconContent' => '',
            'customJS'    => '',
            'customCSS'   => '',
            'enabled'     => true,
            'isCustom'    => false
        ];
    }

    public function getVolumePanelConfig($position = 2)
    {
        return [
            'id'          => 'volumePanel',
            'position'    => $position,
            'title'       => 'Volume',
            'iconContent' => '',
            'customJS'    => '',
            'customCSS'   => '',
            'enabled'     => false,
            'isCustom'    => false,
            'vertical'    => false,
            'inline'      => true
        ];
    }

    public function getSkipBackwardConfig($position = 3)
    {
        return [
            'id'          => 'skipBackward',
            'position'    => $position,
            'title'       => 'Skip Backward',
            'iconContent' => '',
            'customJS'    => '',
            'customCSS'   => '',
            'enabled'     => false,
            'isCustom'    => false
        ];
    }

    public function getSkipForwardConfig($position = 4)
    {
        return [
            'id'          => 'skipForward',
            'position'    => $position,
            'title'       => 'Skip Forward',
            'iconContent' => '',
            'customJS'    => '',
            'customCSS'   => '',
            'enabled'     => false,
            'isCustom'    => false
        ];
    }

    public function getProgressControlConfig($position = 5)
    {
        return [
            'id'          => 'progressControl',
            'position'    => $position,
            'title'       => 'Progress',
            'iconContent' => '',
            'customJS'    => '',
            'customCSS'   => '',
            'enabled'     => true,
            'isCustom'    => false
        ];
    }

    public function getRemainingTimeDisplayConfig($position = 6)
    {
        return [
            'id'              => 'remainingTimeDisplay',
            'position'        => $position,
            'title'           => 'Remaining Time',
            'iconContent'     => '',
            'customJS'        => '',
            'customCSS'       => '',
            'enabled'         => false,
            'isCustom'        => false,
            'displayNegative' => false
        ];
    }

    public function getPictureInPictureToggleConfig($position = 7)
    {
        return [
            'id'          => 'pictureInPictureToggle',
            'position'    => $position,
            'title'       => 'Picture In Picture',
            'iconContent' => '',
            'customJS'    => '',
            'customCSS'   => '',
            'enabled'     => false,
            'isCustom'    => false
        ];
    }

    public function getPlaybackRateMenuButtonConfig($position = 8)
    {
        return [
            'id'          => 'playbackRateMenuButton',
            'position'    => $position,
            'title'       => '',
            'iconContent' => '',
            'customJS'    => '',
            'customCSS'   => '',
            'enabled'     => false,
            'isCustom'    => false
        ];
    }

    public function getFullscreenToggleConfig($position = 9)
    {
        return [
            'id'          => 'fullscreenToggle',
            'position'    => $position,
            'title'       => 'Fullscreen',
            'iconContent' => '',
            'customJS'    => '',
            'customCSS'   => '',
            'enabled'     => false,
            'isCustom'    => false
        ];
    }

    public function getChildrenConfig()
    {
        return []; // Always return an empty because we manage position dynamically
    }
}
