<?php

namespace AutoCraftPlayer\App\Helpers;

use AutoCraftPlayer\App\Services\Helper;
use AutoCraftPlayer\Framework\Support\Facades\Config;

use function AutoCraftPlayer\getOption;

class MediaHelper
{
    public static function getConfigByType($type)
    {
        $config       = Config::get($type);
        $globalConfig = self::getGlobalSettings($type);

        return Helper::arrayMergeRecursive($config, $globalConfig);
    }

    public static function getGlobalSettings($type = null)
    {
        $globalSettings = getOption('_global_settings');

        if ($type) {
            return $globalSettings[$type] ?? [];
        }

        return $globalSettings;
    }

    public static function getAllWpPublicPosts()
    {
        global $wpdb;

        $public_post_types = get_post_types(['public' => true], 'names');

        if (empty($public_post_types)) {
            return [];
        }

        $placeholders = implode(',', array_fill(0, count($public_post_types), '%s'));

        $query = "
        SELECT ID AS id, post_title AS title
        FROM {$wpdb->posts}
        WHERE post_type IN ($placeholders)
          AND post_status = %s
    ";

        $prepared_query = $wpdb->prepare($query, array_merge($public_post_types, ['publish']));

        $results = $wpdb->get_results($prepared_query, ARRAY_A);

        return $results;
    }

}
