<?php

namespace AutoCraftPlayer\App\Helpers;

class CustomControls
{
    public function getTotalDurationConfig($position = 0)
    {
        return [
            'id'          => 'totalDuration',
            'position'    => $position,
            'title'       => 'Total Duration',
            'iconContent' => '<div class="total-duration-display">--:--</div>',
            'customCSS'   => '',
            'customJS'    => "
// Find the display element
const displayElement = button.el().querySelector('.total-duration-display');

// Format time function
function formatTime(seconds) {
    if (isNaN(seconds) || seconds === Infinity || seconds <= 0) {
        return '--:--';
    }

    seconds = Math.floor(seconds);

    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor((seconds % 3600) / 60);
    const secs = seconds % 60;

    const showHours = hours > 0;

    let formattedTime = '';

    if (showHours) {
        formattedTime += `\${hours}:`;
        formattedTime += `\${minutes < 10 ? '0' : ''}\${minutes}:`;
    } else {
        formattedTime += `\${minutes}:`;
    }

    formattedTime += `\${secs < 10 ? '0' : ''}\${secs}`;

    return formattedTime;
}

// Update function
function updateDuration() {
    const duration = player.duration();

    if (displayElement) {
        displayElement.textContent = formatTime(duration);
    }
}

// Initial update
updateDuration();

// Update on events
player.on('loadedmetadata', updateDuration);
player.on('durationchange', updateDuration);

// Optional: Use content object if available
if (content && content.metadata && content.metadata.duration) {
    // If you have duration in content metadata already
    displayElement.textContent = formatTime(content.metadata.duration);
}

// Disable click behavior for this control
button.off('click');
            ",
            'enabled'     => false,
            'isCustom'    => true,
            'isReadOnly'  => true
        ];
    }

    public function getTitleTrackConfig($position = 0)
    {
        return [
            'id'          => 'titleTrac',
            'position'    => $position,
            'title'       => 'Track Title',
            'iconContent' => '
    <div class="track-title-display">Loading...</div>
            ',
            'customCSS'   => '
    .vjs-control.acp-button-titletrac {
      width: auto;
      min-width: 120px;
      max-width: 200px;
      padding: 0 10px;
      display: flex;
      align-items: center;
      cursor: default;
    }
    
    .vjs-control.acp-button-titletrac .track-title-display {
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .vjs-control.acp-button-titletrac {
        max-width: 150px;
      }
    }
            ',
            'customJS'    => "
    // Find the display element
    const titleElement = button.el().querySelector('.track-title-display');
    
    // Function to update track title from content
    function updateTrackTitle() {
      // Default fallback value
      let title = 'Unknown Track';
      
      // Get title from content object if available
      if (content && content.title) {
        title = content.title;
      }
      
      // Update the element
      if (titleElement) {
        titleElement.textContent = title;
      }
    }
    
    // Initial update
    updateTrackTitle();
    
    // Update on player events
    player.on('loadstart', updateTrackTitle);
    
    // Disable click behavior for this control
    button.off('click');
            ",
            'enabled'     => false,
            'isCustom'    => true,
            'isReadOnly'  => true
        ];
    }
}
