<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Variable to track if CSS/JS has already been output on the page (for optimization)
$GLOBALS['adbwdAssetsLoaded'] = false; // Global variable updated to CamelCase

// --- 3. SHORTCODE FUNCTION ---

/**
 * Renders a single, configurable auto-download button.
 */
function adbwd_renderbuttonsshortcode( $atts ) { // Function name updated
    // Get global style and behavior settings from the database
    $global_options = get_option( ADBWD_SETTINGS_NAME );

    // Define defaults based on global options (using new hyphenated keys)
    $default_text       = isset( $global_options['btn-text'] ) ? $global_options['btn-text'] : 'Download File';
    $default_time       = isset( $global_options['default-time'] ) ? $global_options['default-time'] : 5;
    $default_waiting_text = isset( $global_options['waiting-text'] ) ? $global_options['waiting-text'] : 'Preparing download in {seconds} seconds...';
    $default_btn_color  = isset( $global_options['btn-color'] ) ? $global_options['btn-color'] : '#4CAF50';
    $default_btn_hover_color = isset( $global_options['btn-hover-color'] ) ? $global_options['btn-hover-color'] : '#3e8e41';
    $default_wait_color = isset( $global_options['wait-color'] ) ? $global_options['wait-color'] : '#FFA500';
    $default_btn_text_color = isset( $global_options['btn-text-color'] ) ? $global_options['btn-text-color'] : '#FFFFFF';
    $default_btn_radius = isset( $global_options['btn-radius'] ) ? $global_options['btn-radius'] : 30;
    $default_btn_shadow = isset( $global_options['btn-shadow'] ) ? $global_options['btn-shadow'] : '0 0 8px rgba(0, 0, 0, 0.4)';
    $default_font_size  = isset( $global_options['btn-font-size'] ) ? $global_options['btn-font-size'] : 18;
    $default_card_bg    = isset( $global_options['card-bg'] ) ? $global_options['card-bg'] : 'linear-gradient(135deg, #1d4ed8, #3b82f6)';
    $default_card_color = isset( $global_options['card-color'] ) ? $global_options['card-color'] : '#FFFFFF';
    $default_card_radius= isset( $global_options['card-radius'] ) ? $global_options['card-radius'] : 5;
    $default_card_font_size= isset( $global_options['card-font-size'] ) ? $global_options['card-font-size'] : 14; 

    $atts = shortcode_atts(
        array(
            'url'           => '', 
            'name'          => '', 
            'time'          => $default_time,
            'text'          => $default_text,
            'waiting_text'  => $default_waiting_text,
            'btn_color'     => $default_btn_color,
            'btn_hover_color'=> $default_btn_hover_color, 
            'wait_color'    => $default_wait_color,
            'btn_text_color'=> $default_btn_text_color,
            'btn_radius'    => $default_btn_radius,
            'btn_shadow'    => $default_btn_shadow,
            'font_size'     => $default_font_size,
            'card_bg'       => $default_card_bg,
            'card_color'    => $default_card_color,
            'card_radius'   => $default_card_radius,
            'card_font_size'=> $default_card_font_size,
        ),
        $atts,
        'auto-download-button' // Shortcode name updated here
    );

    if ( empty( $atts['url'] ) ) {
        return '<p style="color: red;">Error: The [auto-download-button] shortcode requires a "url" attribute to be set.</p>';
    }

    // Generate a unique ID for this instance
    $unique_id = 'adbwd-' . uniqid(); 

    // Prepare CSS variables for dynamic styling.
    $style_vars = "
        --adb-btn-color: " . esc_attr($atts['btn_color']) . ";
        --adb-btn-hover-color: " . esc_attr($atts['btn_hover_color']) . ";
        --adb-wait-color: " . esc_attr($atts['wait_color']) . ";
        --adb-btn-text-color: " . esc_attr($atts['btn_text_color']) . "; 
        --adb-btn-radius: " . esc_attr($atts['btn_radius']) . "px;
        --adb-btn-shadow: " . esc_attr($atts['btn_shadow']) . ";
        --adb-btn-font-size: " . esc_attr($atts['font_size']) . "px;
        --adb-card-bg: " . esc_attr($atts['card_bg']) . ";
        --adb-card-color: " . esc_attr($atts['card_color']) . ";
        --adb-card-radius: " . esc_attr($atts['card_radius']) . "px;
        --adb-card-font-size: " . esc_attr($atts['card_font_size']) . "px;
    ";
    
    // Enqueue assets and pass data (only once)
    if ( ! $GLOBALS['adbwdAssetsLoaded'] ) { // Global variable updated
        adbwd_enqueueassets(); // Function name updated
    }
    
    // Localize/Pass unique data for this specific button instance to the JS
    wp_add_inline_script( 
        'adbwd-script', 
        'document.addEventListener("DOMContentLoaded", function() { 
             adbwdInitButton("' . esc_attr($unique_id) . '"); // JS function name updated
        });' 
    );
    
    ob_start();
    ?>
    <div id="<?php echo esc_attr($unique_id); ?>" class="adb-container" style="<?php echo esc_attr($style_vars); ?>">
        <div class="file-flashcard-wrapper">
          <button 
            class="delayed-autodownload-btn" 
            data-url="<?php echo esc_url($atts['url']); ?>" 
            data-download-name="<?php echo esc_attr($atts['name']); ?>"
            data-time="<?php echo esc_attr($atts['time']); ?>"
            data-waiting-text="<?php echo esc_attr($atts['waiting_text']); ?>">
            <?php echo esc_html($atts['text']); ?>
          </button>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode( 'auto-download-button', 'adbwd_renderbuttonsshortcode' ); // Shortcode name and callback updated

// --- 4. ASSET ENQUEUING FUNCTION ---

function adbwd_enqueueassets() { // Function name updated
    if ( $GLOBALS['adbwdAssetsLoaded'] ) { // Global variable updated
        return;
    }

    // Enqueue CSS
    wp_enqueue_style( 'adbwd-style', ADBWD_PLUGIN_URL . 'assets/css/adbwd-style.css', array(), '4.6' ); 
    
    // Enqueue JS
    wp_enqueue_script( 'adbwd-script', ADBWD_PLUGIN_URL . 'assets/js/adbwd-script.js', array('jquery'), '4.6', true ); 

    $GLOBALS['adbwdAssetsLoaded'] = true;
}
add_action( 'wp_enqueue_scripts', 'adbwd_enqueueassets' ); // Hook callback updated