<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// --- 1. SETTINGS API INTEGRATION: REGISTER SETTINGS AND FIELDS ---

function adbwd_registersettings() { // Removed internal underscores
    register_setting( ADBWD_SETTINGS_GROUP, ADBWD_SETTINGS_NAME, 'adbwd_sanitizeoptions' ); // Function name updated

    add_settings_section( 
        'adbwd-main-section', // Slug updated
        __( 'Global Style & Behavior Settings', 'auto-download-buttons' ), 
        'adbwd_mainsectioncallback', // Function name updated
        ADBWD_PLUGIN_SLUG 
    );
    
    // Updated field slugs (all use hyphens now) and callback function names
    // --- BUTTON STYLE OPTIONS ---
    add_settings_field( 'adb-btn-text', __( 'Default Button Text', 'auto-download-buttons' ), 'adbwd_btntextcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-btn-color', __( 'Button Background Color (Ready)', 'auto-download-buttons' ), 'adbwd_btncolorcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-btn-hover-color', __( 'Button Background Color (Hover)', 'auto-download-buttons' ), 'adbwd_btnhovercolorcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-wait-color', __( 'Button Background Color (Waiting)', 'auto-download-buttons' ), 'adbwd_waitcolorcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-btn-text-color', __( 'Button Text Color', 'auto-download-buttons' ), 'adbwd_btntextcolorcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-btn-radius', __( 'Button Border Radius (px)', 'auto-download-buttons' ), 'adbwd_btnradiuscallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-btn-shadow', __( 'Button Box Shadow (CSS)', 'auto-download-buttons' ), 'adbwd_btnshadowcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-btn-font-size', __( 'Button Text Size (px)', 'auto-download-buttons' ), 'adbwd_btnfontsizecallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    
    // --- FLASHCARD STYLE OPTIONS ---
    add_settings_field( 'adb-card-bg', __( 'Flashcard Background (CSS)', 'auto-download-buttons' ), 'adbwd_cardbgcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-card-color', __( 'Flashcard Text Color', 'auto-download-buttons' ), 'adbwd_cardcolorcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-card-radius', __( 'Flashcard Border Radius (px)', 'auto-download-buttons' ), 'adbwd_cardradiuscallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-card-font-size', __( 'Flashcard Text Size (px)', 'auto-download-buttons' ), 'adbwd_cardfontsizecallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    
    // --- BEHAVIOR FIELDS ---
    add_settings_field( 'adb-default-time', __( 'Default Countdown Time (Seconds)', 'auto-download-buttons' ), 'adbwd_defaulttimecallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
    add_settings_field( 'adb-waiting-text', __( 'Default Waiting Text', 'auto-download-buttons' ), 'adbwd_waitingtextcallback', ADBWD_PLUGIN_SLUG, 'adbwd-main-section' );
}
add_action( 'admin_init', 'adbwd_registersettings' ); // Hook callback updated

/**
 * Sanitizes and validates the settings input.
 */
function adbwd_sanitizeoptions( $input ) { // Function name updated
    $new_input = array();
    
    // Updated array keys from underscores to hyphens
    // Style sanitization
    $new_input['btn-text']   = isset( $input['btn-text'] ) ? sanitize_text_field( $input['btn-text'] ) : 'Download File';
    $new_input['btn-color']  = isset( $input['btn-color'] ) ? ( sanitize_hex_color( $input['btn-color'] ) ? $input['btn-color'] : '#4CAF50' ) : '#4CAF50';
    $new_input['btn-hover-color'] = isset( $input['btn-hover-color'] ) ? ( sanitize_hex_color( $input['btn-hover-color'] ) ? $input['btn-hover-color'] : '#3e8e41' ) : '#3e8e41';
    $new_input['wait-color'] = isset( $input['wait-color'] ) ? ( sanitize_hex_color( $input['wait-color'] ) ? $input['wait-color'] : '#FFA500' ) : '#FFA500';
    $new_input['btn-text-color'] = isset( $input['btn-text-color'] ) ? ( sanitize_hex_color( $input['btn-text-color'] ) ? $input['btn-text-color'] : '#FFFFFF' ) : '#FFFFFF';
    $new_input['btn-radius'] = isset( $input['btn-radius'] ) ? intval( $input['btn-radius'] ) : 30;
    $new_input['btn-shadow'] = isset( $input['btn-shadow'] ) ? sanitize_text_field( $input['btn-shadow'] ) : '0 0 8px rgba(0, 0, 0, 0.4)';
    $new_input['btn-font-size'] = isset( $input['btn-font-size'] ) ? intval( $input['btn-font-size'] ) : 18; 
    
    // Flashcard Style sanitization
    $new_input['card-bg']    = isset( $input['card-bg'] ) ? sanitize_text_field( $input['card-bg'] ) : 'linear-gradient(135deg, #1d4ed8, #3b82f6)';
    $new_input['card-color'] = isset( $input['card-color'] ) ? ( sanitize_hex_color( $input['card-color'] ) ? $input['card-color'] : '#FFFFFF' ) : '#FFFFFF';
    $new_input['card-radius']= isset( $input['card-radius'] ) ? intval( $input['card-radius'] ) : 5;
    $new_input['card-font-size'] = isset( $input['card-font-size'] ) ? intval( $input['card-font-size'] ) : 14; 

    // Behavior sanitization
    $time = isset( $input['default-time'] ) ? intval( $input['default-time'] ) : 5;
    $new_input['default-time'] = ( $time > 0 && $time <= 60 ) ? $time : 5; 
    $new_input['waiting-text'] = isset( $input['waiting-text'] ) ? sanitize_text_field( $input['waiting-text'] ) : 'Preparing download in {seconds} seconds...';

    // Handle the new 'Max Download Buttons' setting	
    if ( isset( $input['max-image-buttons'] ) ) {	
    $value = intval( $input['max-image-buttons'] );	
    // Clamp the value between 1 and 4	
    $new_input['max-image-buttons'] = max( 1, min( 4, $value ) );	
    } else {	
    // Ensure the setting is still present even if the field wasn't submitted (e.g., if you add other tabs later)	
    $new_input['max-image-buttons'] = 1;	
}

    return $new_input;
}

// Section callback
function adbwd_mainsectioncallback() { // Function name updated
    echo '<p>' . esc_html__( 'Use these settings to define the default styles and countdown behavior for your Auto Download Buttons. These defaults can be overridden by using shortcode attributes.', 'auto-download-buttons' ) . '</p>';

// START: Plugin Information and Support Block
    echo '<div class="adbwd-info-section" style="margin-top: 20px; padding: 15px; border: 1px solid #c3c4c7; border-left: 4px solid #007cba; background-color: #ffffff; border-radius: 3px;">';
    
    echo '<h2 style="margin-top: 0; font-size: 1.2em; border-bottom: 1px solid #eee; padding-bottom: 10px;">' . esc_html__( 'Plugin Information & Support', 'auto-download-buttons' ) . '</h2>';
    
    echo '<p style="margin-bottom: 10px;">' . 
         esc_html__( 'This plugin is ', 'auto-download-buttons' ) . 
         '<strong>' . esc_html__( 'Auto Download Buttons', 'auto-download-buttons' ) . '</strong>' . 
         esc_html__( ' by Tech-Turf. For more details on features, updates, and licensing, please visit our official page.', 'auto-download-buttons' ) . 
         '</p>';
    
    echo '<ul style="list-style: none; margin: 0; padding: 0;">';
    
    // Powered By Link
    $powered_by_url = 'https://tech-turf.com/';
    echo '<li style="margin-bottom: 8px;">';
    echo '<span class="dashicons dashicons-external" style="color: #007cba;"></span>';
    echo '<strong>' . esc_html__( 'Powered By:', 'auto-download-buttons' ) . '</strong> ';
    echo '<a href="' . esc_url( $powered_by_url ) . '" target="_blank">' . esc_html__( 'Tech-Turf (Official Page)', 'auto-download-buttons' ) . '</a>';
    echo '</li>';

    // User Guide Link
    $guide_url = 'https://tech-turf.com/auto-download-buttons';
    echo '<li style="margin-bottom: 8px;">';
    echo '<span class="dashicons dashicons-book-alt" style="color: #007cba;"></span>';
    echo '<strong>' . esc_html__( 'User Guide:', 'auto-download-buttons' ) . '</strong> ';
    echo '<a href="' . esc_url( $guide_url ) . '" target="_blank">' . esc_html__( 'View Detailed Usage Instructions', 'auto-download-buttons' ) . '</a>';
    echo '</li>';
    
    // Contact Support Link
    $support_url = 'https://tech-turf.com/contact-us/';
    echo '<li>';
    echo '<span class="dashicons dashicons-admin-users" style="color: #007cba;"></span>';
    echo '<strong>' . esc_html__( 'Contact Support:', 'auto-download-buttons' ) . '</strong> ';
    echo '<a href="' . esc_url( $support_url ) . '" target="_blank">' . esc_html__( 'Get Help or Report an Issue', 'auto-download-buttons' ) . '</a>';
    echo '</li>';
    
    echo '</ul>';
    echo '</div>';
    // END: Plugin Information and Support Block
}

// --- FIELD CALLBACK FUNCTIONS (All setting fields) ---

function adbwd_btntextcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['btn-text'] ) ? $options['btn-text'] : 'Download File';
    echo '<input type="text" id="adb-btn-text" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[btn-text]" value="' . esc_attr( $value ) . '" class="regular-text"/>';
    echo '<p class="description">The default text shown on the button before clicking.</p>';
}

function adbwd_btncolorcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['btn-color'] ) ? $options['btn-color'] : '#4CAF50';
    echo '<input type="color" id="adb-btn-color" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[btn-color]" value="' . esc_attr( $value ) . '"/>';
    echo '<p class="description">e.g., #4CAF50 (Green) for the **ready** state.</p>';
}

function adbwd_btnhovercolorcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['btn-hover-color'] ) ? $options['btn-hover-color'] : '#3e8e41';
    echo '<input type="color" id="adb-btn-hover-color" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[btn-hover-color]" value="' . esc_attr( $value ) . '"/>';
    echo '<p class="description">e.g., #3e8e41 (Darker Green) for the **ready state hover** effect.</p>';
}

function adbwd_waitcolorcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['wait-color'] ) ? $options['wait-color'] : '#FFA500';
    echo '<input type="color" id="adb-wait-color" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[wait-color]" value="' . esc_attr( $value ) . '"/>';
    echo '<p class="description">e.g., #FFA500 (Orange) for the **waiting** state.</p>';
}

function adbwd_btntextcolorcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['btn-text-color'] ) ? $options['btn-text-color'] : '#FFFFFF';
    echo '<input type="color" id="adb-btn-text-color" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[btn-text-color]" value="' . esc_attr( $value ) . '"/>';
    echo '<p class="description">e.g., #FFFFFF (White). Applies to both ready and waiting states.</p>';
}

function adbwd_btnradiuscallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['btn-radius'] ) ? $options['btn-radius'] : 30;
    echo '<input type="number" min="0" step="1" id="adb-btn-radius" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[btn-radius]" value="' . esc_attr( $value ) . '" class="small-text"/>';
    echo '<p class="description">e.g., 30 for rounded corners, 0 for square.</p>';
}

function adbwd_btnshadowcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['btn-shadow'] ) ? $options['btn-shadow'] : '0 0 8px rgba(0, 0, 0, 0.4)';
    echo '<input type="text" id="adb-btn-shadow" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[btn-shadow]" value="' . esc_attr( $value ) . '" class="regular-text"/>';
    echo '<p class="description">e.g., 0 0 8px rgba(0, 0, 0, 0.4).</p>';
}

function adbwd_btnfontsizecallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['btn-font-size'] ) ? $options['btn-font-size'] : 18;
    echo '<input type="number" min="10" max="40" step="1" id="adb-btn-font-size" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[btn-font-size]" value="' . esc_attr( $value ) . '" class="small-text"/>';
    echo '<p class="description">The default font size for the button text (in pixels).</p>';
}

function adbwd_cardbgcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['card-bg'] ) ? $options['card-bg'] : 'linear-gradient(135deg, #1d4ed8, #3b82f6)';
    echo '<input type="text" id="adb-card-bg" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[card-bg]" value="' . esc_attr( $value ) . '" class="regular-text"/>';
    echo '<p class="description">e.g., #3b82f6 or linear-gradient(...).</p>';
}

function adbwd_cardcolorcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['card-color'] ) ? $options['card-color'] : '#FFFFFF';
    echo '<input type="color" id="adb-card-color" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[card-color]" value="' . esc_attr( $value ) . '"/>';
    echo '<p class="description">Text and icon color for the flashcard.</p>';
}

function adbwd_cardradiuscallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['card-radius'] ) ? $options['card-radius'] : 5;
    echo '<input type="number" min="0" step="1" id="adb-card-radius" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[card-radius]" value="' . esc_attr( $value ) . '" class="small-text"/>';
    echo '<p class="description">e.g., 5 for rounded corners.</p>';
}

function adbwd_cardfontsizecallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['card-font-size'] ) ? $options['card-font-size'] : 14;
    echo '<input type="number" min="10" max="30" step="1" id="adb-card-font-size" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[card-font-size]" value="' . esc_attr( $value ) . '" class="small-text"/>';
    echo '<p class="description">The default font size for the flashcard text (in pixels).</p>';
}

function adbwd_defaulttimecallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['default-time'] ) ? $options['default-time'] : 5;
    echo '<input type="number" min="1" max="60" step="1" id="adb-default-time" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[default-time]" value="' . esc_attr( $value ) . '" class="small-text"/>';
    echo '<p class="description">The default number of seconds for the countdown (1-60).</p>';
}

function adbwd_waitingtextcallback() { // Function name updated
    $options = get_option( ADBWD_SETTINGS_NAME );
    $value = isset( $options['waiting-text'] ) ? $options['waiting-text'] : 'Preparing download in {seconds} seconds...';
    echo '<input type="text" id="adb-waiting-text" name="' . esc_attr(ADBWD_SETTINGS_NAME) . '[waiting-text]" value="' . esc_attr( $value ) . '" class="regular-text"/>';
    echo '<p class="description">The text to display. Use <strong>{seconds}</strong> for the remaining time.</p>';
}


// --- 2. ADMIN MENU AND PAGE CREATION ---
function adbwd_addadminmenu() { // Function name updated
    add_menu_page(
        __( 'Auto Download Buttons Settings', 'auto-download-buttons' ), 
        'Auto Download Buttons', 
        'manage_options', 
        ADBWD_PLUGIN_SLUG, 
        'adbwd_optionspagehtml', // Function name updated
        'dashicons-download', 
        30 
    );
}
add_action( 'admin_menu', 'adbwd_addadminmenu' );

function adbwd_optionspagehtml() { // Function name updated
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }
    ?>
    <div class="wrap">
        <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields( ADBWD_SETTINGS_GROUP );
            do_settings_sections( ADBWD_PLUGIN_SLUG );
            submit_button( 'Save Global Settings' );
            ?>
        </form>
    </div>
    <?php
}