<?php 
/**
 * Auto Download Buttons with Countdown Timer
 * Plugin Name: Auto Download Buttons
 * Description: Auto Download Buttons with Countdown or Delay Timer: This plugin implements a single, dynamic button that initiates a file download after a specified countdown, featuring a hover flashcard effect. The button and flashcard styles and countdown are customizable via shortcode attributes OR a global plugin dashboard.
 * Version: 1.0.2
 * @copyright  Copyright (C) tech-turf.com, Tech-Turf - admin@tech-turf.com
 * @link   https://tech-turf.com/
 * Author: Tech-Turf
 * Author URI: https://tech-turf.com/
 * Shortcode: [auto-download-button]
 * License: GPLv3 or later
 * License URI: https://www.gnu.org/licenses/gpl-3.0.txt
 */


// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// --- CONSTANTS ---
define( 'ADBWD_PLUGIN_SLUG', 'adbwd-download-buttons' );
// Changed values to use hyphens for settings slugs
define( 'ADBWD_SETTINGS_GROUP', 'adbwd-settings-group' );
define( 'ADBWD_SETTINGS_NAME', 'adbwd-style-options' );
define( 'ADBWD_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'ADBWD_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// --- FILE INCLUSIONS ---

// Include Admin Settings and Menu functions
require_once ADBWD_PLUGIN_DIR . 'includes/adbwd-settings.php';

// Include Shortcode functions and asset handling
require_once ADBWD_PLUGIN_DIR . 'includes/adbwd-shortcode.php';

require_once ADBWD_PLUGIN_DIR . 'includes/adbwd-multi-downloads.php';

/**
 * Add action links (Settings and Usage Guide) to the plugins page.
 */
function adbwd_plugin_action_links( $links ) {
    // URL for the Settings page using the defined plugin slug
    $settings_url = add_query_arg( 
        array( 'page' => ADBWD_PLUGIN_SLUG ), 
        admin_url( 'admin.php' ) 
    );
    $settings_link = '<a href="' . esc_url( $settings_url ) . '">' . __( 'Settings', 'auto-download-buttons' ) . '</a>';

    // Add the new links to the beginning of the existing links array
    array_unshift($links, $settings_link);

    return $links;
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'adbwd_plugin_action_links' );

/**
 * Add custom links (like Support/Usage Guide) to the metadata row below the description.
 */
function adbwd_plugin_row_meta_links( $plugin_meta, $plugin_file ) {
    // Check if the current plugin is YOUR plugin
    if ( plugin_basename( __FILE__ ) === $plugin_file ) {
        // 1. Add Usage Guide link (External, linking to the author's site)
        $user_link = '<a href="' . esc_url( 'https://tech-turf.com/auto-download-buttons/' ) . '" target="_blank">' . __( 'User Guide', 'auto-download-buttons' ) . '</a>';
        
        // 2. Add Settings link (Internal, linking to the admin page)
        $support_link = '<a href="' . esc_url( 'https://tech-turf.com/contact-us' ) . '" target="_blank">' . __( 'Contact Support', 'auto-download-buttons' ) . '</a>';

        // Add the links to the plugin meta array
        $plugin_meta[] = $user_link;
        $plugin_meta[] = $support_link;
    }

    return $plugin_meta;
}
add_filter( 'plugin_row_meta', 'adbwd_plugin_row_meta_links', 10, 2 );