/**
 * Plugin Name: Auto Download Buttons
 * Author: Tech-Turf
 * Version: 1.0.2
 */

window.adbwdInitButton = function(uniqueId) { // Global function name updated to CamelCase
    const container = document.getElementById(uniqueId);
    if (!container) return;

    const wrapper = container.querySelector('.file-flashcard-wrapper');
    const button = wrapper.querySelector('.delayed-autodownload-btn');
    
    if (!button) return;

    const DOWNLOAD_URL = button.getAttribute('data-url');
    const CUSTOM_DOWNLOAD_NAME = button.getAttribute('data-download-name');
    const WAITING_TEXT_TEMPLATE = button.getAttribute('data-waiting-text');

    // --- Utility Functions ---
    // These internal functions already use acceptable camel casing and do not need modification.
    function getFileDetails(url) {
        let filename = 'download.file';
        let extension = 'FILE';
        let iconChar = '📦';

        try {
            const urlObj = new URL(url);
            const path = urlObj.pathname;
            const parts = path.split('/');
            const filenameWithExt = parts.pop() || 'download.file';
            filename = filenameWithExt.split('?')[0].split('#')[0];

            const extParts = filename.split('.');
            extension = extParts.length > 1 ? extParts.pop().toUpperCase() : 'FILE';
        } catch (e) {
            const pathParts = url.split('/');
            const simpleFilename = pathParts[pathParts.length - 1].split('?')[0].split('#')[0];
            filename = simpleFilename;

            const simpleExtParts = simpleFilename.split('.');
            extension = simpleExtParts.length > 1 ? simpleExtParts.pop().toUpperCase() : 'FILE';
        }

        if (extension === 'PDF') { iconChar = '📄'; }
        else if (['JPG', 'PNG', 'WEBP', 'GIF'].includes(extension)) { iconChar = '🖼️'; }
        else if (['ZIP', 'RAR', '7Z', 'GZ'].includes(extension)) { iconChar = '💾'; }
        else if (extension.startsWith('DOC')) { iconChar = '📝'; }
        else if (extension.startsWith('XLS') || extension === 'CSV') { iconChar = '📊'; }
        else if (extension.startsWith('PPT')) { iconChar = '🖼️'; }

        return { filename, extension, iconChar };
    }

    function createFlashcard(wrapper, details) {
        const flashcardHtml = `
            <div class='file-info-flashcard'>
                <span class='file-icon'>${details.iconChar}</span>
                <span class='file-extension'>${details.extension}</span>
            </div>
        `;
        // Inserts the flashcard right before the button in the wrapper
        wrapper.insertAdjacentHTML('afterbegin', flashcardHtml);
    }
    // --- End Utility Functions ---

    // 1. Initialize Flashcard Content dynamically
    const fileDetails = getFileDetails(DOWNLOAD_URL);
    createFlashcard(wrapper, fileDetails);

    const FINAL_DOWNLOAD_NAME = CUSTOM_DOWNLOAD_NAME || fileDetails.filename;
    const INITIAL_TEXT = button.textContent.trim();
    const flashcard = wrapper.querySelector('.file-info-flashcard'); 

    // 2. Attach the click handler
    button.addEventListener('click', function handler(e) {
        e.preventDefault();

        if (button.classList.contains('waiting')) {
            return;
        }
        
        const COUNTDOWN_SECONDS = parseInt(button.getAttribute('data-time'), 10);

        button.disabled = true;
        button.classList.add('waiting');

        let secondsLeft = COUNTDOWN_SECONDS;
        button.textContent = WAITING_TEXT_TEMPLATE.replace('{seconds}', secondsLeft);

        const countdownInterval = setInterval(() => {
            secondsLeft--;

            button.textContent = WAITING_TEXT_TEMPLATE.replace('{seconds}', secondsLeft);

            if (secondsLeft <= 0) {
                clearInterval(countdownInterval);

                button.textContent = 'Starting Download...';
                button.classList.remove('waiting');

                // CORE DOWNLOAD LOGIC: FORCE DOWNLOAD
                const tempLink = document.createElement('a');
                tempLink.href = DOWNLOAD_URL;
                tempLink.download = FINAL_DOWNLOAD_NAME;

                document.body.appendChild(tempLink);
                tempLink.click();
                document.body.removeChild(tempLink);

                // Restore button state after a delay
                setTimeout(() => {
                    button.textContent = INITIAL_TEXT;
                    button.disabled = false;
                }, 5000);
            }
        }, 1000);
    }, {once: false});
};