<?php
/**
 * Uninstall file for Auto-Disable Unused Image Sizes plugin
 *
 * This file is executed when the plugin is deleted from WordPress.
 * It removes all plugin data and options from the database.
 *
 * @package Auto_Disable_Unused_Image_Sizes
 * @version 1.0.0
 */

// If uninstall not called from WordPress, exit
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Delete plugin options
delete_option( 'adis_disabled_image_sizes' );

// Clean up any transients if they exist
delete_transient( 'adis_image_sizes_cache' );
