jQuery(document).ready(function ($) {
    if (typeof AUTHYO_PASSWORDLESS_EMAIL_SUBSCRIPTION === 'undefined') return;

    var config = AUTHYO_PASSWORDLESS_EMAIL_SUBSCRIPTION;
    var $popup = $('#authyo-passwordless-email-subscription-popup');
    var $form = $('#authyo-passwordless-email-subscription-form');
    var $input = $('#authyo-passwordless-email-subscription-input');
    var $error = $('.authyo-cf7-email-subscription-error');
    var $submitBtn = $('.authyo-passwordless-email-subscription-submit');

    // Show popup with a slight delay
    setTimeout(function () {
        $popup.fadeIn(400);
    }, 500);

    function dismissPopup() {
        $popup.fadeOut(300, function () {
            $popup.remove();
        });
    }

    $form.on('submit', function (e) {
        e.preventDefault();

        var email = $input.val();
        if (!email) return;

        $submitBtn.prop('disabled', true).text(config.i18n.submitting);
        $error.hide();

        $.ajax({
            url: config.ajax_url,
            type: 'POST',
            data: {
                action: 'authyo_passwordless_submit_email_subscription',
                nonce: config.nonce,
                email: email
            },
            success: function (response) {
                if (response.success) {
                    $form.hide();
                    $popup.find('.authyo-cf7-email-subscription-body').append(
                        '<div class="authyo-cf7-email-subscription-success">' + response.data.message + '</div>'
                    );
                    setTimeout(dismissPopup, 2000);
                } else {
                    $error.text(response.data.message).show();
                    $submitBtn.prop('disabled', false).text(config.i18n.submit || 'Subscribe');
                }
            },
            error: function () {
                $error.text('An error occurred. Please try again.').show();
                $submitBtn.prop('disabled', false).text(config.i18n.submit || 'Subscribe');
            }
        });
    });

    $('.authyo-passwordless-email-subscription-skip, .authyo-cf7-email-subscription-close').on('click', function () {
        dismissPopup();

        $.ajax({
            url: config.ajax_url,
            type: 'POST',
            data: {
                action: 'authyo_passwordless_dismiss_email_subscription',
                nonce: config.nonce
            }
        });
    });
});
