jQuery(document).ready(function ($) {
    if (typeof AUTHYO_PASSWORDLESS_DEACTIVATION === 'undefined') return;

    var config = AUTHYO_PASSWORDLESS_DEACTIVATION;
    var $pluginRow = $('tr[data-plugin="' + config.plugin_basename + '"]');

    // If we can't find by data-plugin, try to find row by slug if data-slug exists
    if ($pluginRow.length === 0) {
        var slug = config.plugin_slug;
        $pluginRow = $('tr[data-slug="' + slug + '"]');
    }

    var $deactivateLink = $pluginRow.find('a.deactivate');

    // If still not found, search for the link by its HREF containing 'deactivate' and the plugin folder
    if ($deactivateLink.length === 0) {
        var pluginFolder = config.plugin_basename.split('/')[0];
        $deactivateLink = $pluginRow.find('a[href*="action=deactivate"][href*="plugin=' + encodeURIComponent(config.plugin_basename) + '"]');
    }

    if ($deactivateLink.length === 0) {
        console.warn('Authyo Tracker: Deactivate link not found for ' + config.plugin_basename);
        return;
    }

    var modalHtml = `
        <div class="authyo-passwordless-deactivation-overlay"></div>
        <div class="authyo-passwordless-deactivation-modal">
            <div class="authyo-passwordless-deactivation-header">
                <h2>${config.i18n.title}</h2>
            </div>
            <div class="authyo-passwordless-deactivation-body">
                <p class="authyo-passwordless-deactivation-question">${config.i18n.question}</p>
                <div class="authyo-passwordless-deactivation-reasons">
                    <label class="authyo-passwordless-deactivation-reason">
                        <input type="radio" name="reason" value="temporary" checked>
                        <span>${config.i18n.reason_temporary}</span>
                    </label>
                    <label class="authyo-passwordless-deactivation-reason">
                        <input type="radio" name="reason" value="complicated">
                        <span>${config.i18n.reason_complicated}</span>
                    </label>
                    <label class="authyo-passwordless-deactivation-reason">
                        <input type="radio" name="reason" value="alternative">
                        <span>${config.i18n.reason_alternative}</span>
                    </label>
                    <label class="authyo-passwordless-deactivation-reason">
                        <input type="radio" name="reason" value="other">
                        <span>${config.i18n.reason_other}</span>
                    </label>
                </div>
                <textarea class="authyo-passwordless-deactivation-details" placeholder="${config.i18n.other_placeholder}"></textarea>
            </div>
            <div class="authyo-passwordless-deactivation-footer">
                <button type="button" class="authyo-passwordless-deactivation-skip">${config.i18n.skip}</button>
                <button type="button" class="authyo-passwordless-deactivation-submit">${config.i18n.submit}</button>
            </div>
        </div>
    `;

    $('body').append(modalHtml);

    var $modal = $('.authyo-passwordless-deactivation-modal');
    var $overlay = $('.authyo-passwordless-deactivation-overlay');
    var $details = $('.authyo-passwordless-deactivation-details');

    $deactivateLink.on('click', function (e) {
        e.preventDefault();
        $overlay.fadeIn(200);
        $modal.fadeIn(200);
    });

    $('input[name="reason"]').on('change', function () {
        if ($(this).val() === 'other' || $(this).val() === 'complicated') {
            $details.slideDown(200).focus();
        } else {
            $details.slideUp(200);
        }
    });

    $('.authyo-passwordless-deactivation-skip').on('click', function () {
        window.location.href = $deactivateLink.attr('href');
    });

    $('.authyo-passwordless-deactivation-submit').on('click', function () {
        var $btn = $(this);
        var reason = $('input[name="reason"]:checked').val();
        var details = $details.val();

        $btn.prop('disabled', true).text(config.i18n.submitting);

        $.ajax({
            url: config.ajax_url,
            type: 'POST',
            data: {
                action: 'authyo_passwordless_submit_deactivation_feedback',
                nonce: config.nonce,
                reason: reason,
                details: details
            },
            complete: function () {
                window.location.href = $deactivateLink.attr('href');
            }
        });
    });

    $overlay.on('click', function () {
        $overlay.fadeOut(200);
        $modal.fadeOut(200);
    });
});
