<?php
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete all plugin options
delete_option('authyo_otp_auth_settings');
delete_option('authyo_otp_auth_enable_login');
delete_option('authyo_otp_auth_enable_registration');
delete_option('authyo_otp_auth_app_id');
delete_option('authyo_otp_auth_client_id');
delete_option('authyo_otp_auth_client_secret');
delete_option('authyo_otp_auth_email_enabled');
delete_option('authyo_otp_auth_whatsapp_enabled');
delete_option('authyo_otp_auth_sms_enabled');
delete_option('authyo_otp_auth_voice_enabled');
delete_option('authyo_otp_auth_fallback_enabled');
delete_option('authyo_otp_auth_priority_method');
delete_option('authyo_otp_auth_length');
delete_option('authyo_otp_auth_expiry');
delete_option('authyo_otp_auth_bypass_enabled');
delete_option('authyo_otp_auth_test_phones');
delete_option('authyo_otp_auth_test_emails');
delete_option('authyo_otp_auth_default_country');
delete_option('authyo_otp_auth_version');

// Delete all transients
global $wpdb;
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Plugin uninstall needs to clean up transients
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_authyo_%' OR option_name LIKE '_transient_timeout_authyo_%'");

// Drop custom tables
$authyo_otp_auth_table_name = $wpdb->prefix . 'authyo_otp_auth_logs';

// Check if table exists before dropping
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Plugin uninstall needs to check custom table existence
$authyo_otp_auth_table_exists = $wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $authyo_otp_auth_table_name));

if ($authyo_otp_auth_table_exists) {
    // Escape table name for use in SQL query (table names cannot be prepared, must be escaped)
    $authyo_otp_auth_escaped_table_name = esc_sql($authyo_otp_auth_table_name);
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Plugin uninstall needs to drop custom table, table name is escaped with esc_sql()
    $authyo_otp_auth_result = $wpdb->query("DROP TABLE IF EXISTS `{$authyo_otp_auth_escaped_table_name}`");
    
    // Log error if drop fails
    if (false === $authyo_otp_auth_result && defined('WP_DEBUG') && WP_DEBUG) {
        // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Error logging for uninstall failures
        error_log('Authyo OTP: Failed to drop table ' . $authyo_otp_auth_table_name . ' - ' . $wpdb->last_error);
    }
}

// Clear any scheduled hooks
wp_clear_scheduled_hook('authyo_otp_auth_cleanup_logs'); 