<?php
/**
 * Template for the registration form
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="authyo-otp-auth-container">
    <div class="authyo-otp-auth-form register">
        <h2><?php esc_html_e('Register with OTP', 'authyo-otp-authentication-for-woocommerce'); ?></h2>
        <form id="authyo-otp-authentication-for-woocommerce-register-form" class="authyo-otp-register-form" method="post">
        <?php wp_nonce_field('authyo_otp_auth_register', 'authyo_otp_auth_register_nonce'); ?>
        
        <!-- Messages -->
        <div id="register-message" class="message">
            <?php
            // Check for message in transient (more secure than GET parameters)
            $authyo_otp_auth_message_data = get_transient('authyo_otp_auth_register_message_' . session_id());
            if ($authyo_otp_auth_message_data && is_array($authyo_otp_auth_message_data)) {
                delete_transient('authyo_otp_auth_register_message_' . session_id());
                $authyo_otp_auth_message_class = isset($authyo_otp_auth_message_data['type']) && $authyo_otp_auth_message_data['type'] === 'error' ? 'error' : 'success';
                echo '<p class="' . esc_attr($authyo_otp_auth_message_class) . '">' . esc_html($authyo_otp_auth_message_data['message']) . '</p>';
            }
            ?>
        </div>

        <div class="form-row">
            <label for="reg_email"><?php esc_html_e('Email address or Mobile number', 'authyo-otp-authentication-for-woocommerce'); ?> <span class="required">*</span></label>
            <noscript>
                <p class="notice notice-warning">
                    <?php esc_html_e('JavaScript is required for mobile OTP authentication. Please enable JavaScript or use email registration.', 'authyo-otp-authentication-for-woocommerce'); ?>
                </p>
            </noscript>
            <div class="phone-input-wrapper">
                <select id="register-country-code" name="country_code" class="authyo-country-select" style="display: none;" aria-label="<?php esc_attr_e('Select country code for mobile number', 'authyo-otp-authentication-for-woocommerce'); ?>">
                    <option value=""><?php esc_html_e('Select Country', 'authyo-otp-authentication-for-woocommerce'); ?></option>
                </select>
                <input type="text" class="input-text" name="email" id="reg_email" autocomplete="off" required aria-required="true" aria-describedby="register-number-preview" />
            </div>
            <span id="register-number-preview" class="number-preview" role="status" aria-live="polite" style="display:none;"></span>
        </div>

        <!-- OTP Field (initially hidden) -->
        <div class="form-row otp-field" style="display:none;">
            <label for="reg_otp"><?php esc_html_e('Enter OTP', 'authyo-otp-authentication-for-woocommerce'); ?> <span class="required">*</span></label>
            <input type="text" class="input-text" name="otp" id="reg_otp" />
            <input type="hidden" name="maskId" id="register-mask-id" value="" />
            
            <button type="button" id="resend-register-otp" class="button button-secondary resend-otp-btn" style="margin-top: 10px;">
                <span class="timer"><?php esc_html_e('Resend OTP', 'authyo-otp-authentication-for-woocommerce'); ?></span>
            </button>
            
            <div class="resend-otp-section authyo-hidden">
                <p class="resend-text"><?php esc_html_e('Didn\'t receive OTP? Try Resend OTP via:', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                <div class="resend-methods-grid">
                    <button type="button" class="resend-method-btn" data-method="sms">SMS</button>
                    <button type="button" class="resend-method-btn" data-method="whatsapp">WhatsApp</button>
                    <button type="button" class="resend-method-btn" data-method="voice">Voicecall</button>
                </div>
            </div>
        </div>

        <?php do_action('authyo_otp_auth_register_form'); ?>

        <div class="form-row">
            <button type="button" class="button" id="register-with-otp"><?php esc_html_e('Register with OTP', 'authyo-otp-authentication-for-woocommerce'); ?></button>
        </div>
        </form>
    </div>
</div> 