<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="authyo-otp-auth-container">
    <div class="authyo-otp-auth-form login">
        <h2><?php esc_html_e('Login with OTP', 'authyo-otp-authentication-for-woocommerce'); ?></h2>
        <form id="authyo-otp-authentication-for-woocommerce-login-form" class="authyo-otp-login-form" method="post">
        <?php wp_nonce_field('authyo_otp_auth_login', 'authyo_otp_auth_login_nonce'); ?>
        <?php 
        // Check for error message in transient (more secure than GET parameters)
        $authyo_otp_auth_error_message = get_transient('authyo_otp_auth_login_error_' . get_current_user_id());
        if ($authyo_otp_auth_error_message) {
            delete_transient('authyo_otp_auth_login_error_' . get_current_user_id());
            ?>
            <div class="error message">
                <?php echo esc_html($authyo_otp_auth_error_message); ?>
            </div>
            <?php
        }
        ?>
        <div id="login-message" class="message"></div>
        <div class="form-group">
            <label for="login-email"><?php esc_html_e('Email or Mobile Number', 'authyo-otp-authentication-for-woocommerce'); ?></label>
            <noscript>
                <p class="notice notice-warning">
                    <?php esc_html_e('JavaScript is required for mobile OTP authentication. Please enable JavaScript or use email login.', 'authyo-otp-authentication-for-woocommerce'); ?>
                </p>
            </noscript>
            <div class="phone-input-wrapper">
                <select id="login-country-code" name="country_code" class="authyo-country-select" style="display: none;" aria-label="<?php esc_attr_e('Select country code for mobile number', 'authyo-otp-authentication-for-woocommerce'); ?>">
                    <option value=""><?php esc_html_e('Select Country', 'authyo-otp-authentication-for-woocommerce'); ?></option>
                </select>
                <input type="text" id="login-email" name="email" required aria-required="true" aria-describedby="login-number-preview">
            </div>
            <span id="login-number-preview" class="number-preview" role="status" aria-live="polite"><?php esc_html_e('Select country to see formatted number', 'authyo-otp-authentication-for-woocommerce'); ?></span>
        </div>
        <!-- Alternative methods section (shown when SMS fails) -->
        <div class="form-group alternative-methods-section authyo-hidden" style="display: none;">
            <p class="resend-text"><?php esc_html_e('SMS is not supported for this country. Try sending OTP via:', 'authyo-otp-authentication-for-woocommerce'); ?></p>
            <div class="resend-methods-grid">
                <button type="button" class="resend-method-btn alternative-method-btn" data-method="whatsapp">WhatsApp</button>
                <button type="button" class="resend-method-btn alternative-method-btn" data-method="voice">Voice Call</button>
            </div>
        </div>
        <!-- otp-fields -->
        <div class="form-group otp-fields" style="display: none;">
            <label for="login-otp"><?php esc_html_e('Enter OTP', 'authyo-otp-authentication-for-woocommerce'); ?></label>
            <input type="text" id="login-otp" name="otp" required>
            <input type="hidden" name="maskId" id="login-mask-id">
            
            <button type="button" id="resend-login-otp" class="button button-secondary resend-otp-btn" style="margin-top: 10px;">
                <span class="timer"><?php esc_html_e('Resend OTP', 'authyo-otp-authentication-for-woocommerce'); ?></span>
            </button>
            
            <div class="resend-otp-section authyo-hidden">
                <p class="resend-text"><?php esc_html_e('Didn\'t receive OTP? Try Resend OTP via:', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                <div class="resend-methods-grid">
                    <button type="button" class="resend-method-btn" data-method="sms">SMS</button>
                    <button type="button" class="resend-method-btn" data-method="whatsapp">WhatsApp</button>
                    <button type="button" class="resend-method-btn" data-method="voice">Voicecall</button>
                </div>
            </div>
        </div>
        <div class="form-group">
            <button type="button" id="send-login-otp" class="button">
                <?php esc_html_e('SignIn with OTP', 'authyo-otp-authentication-for-woocommerce'); ?>
            </button>
            <button type="submit" id="verify-login-otp" class="button" style="display: none;">
                <?php esc_html_e('Login', 'authyo-otp-authentication-for-woocommerce'); ?>
            </button>
        </div>
        </form>
    </div>
</div>