<?php
/**
 * Template for the authentication form
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$authyo_otp_auth_settings = get_option('authyo_otp_auth_settings', array());
?>

<div class="authyo-otp-auth-container">
    <div class="authyo-otp-auth-form">
        <h2><?php esc_html_e('OTP Authentication', 'authyo-otp-authentication-for-woocommerce'); ?></h2>
        <form id="authyo-otp-authentication-for-woocommerce-form" method="post">
        <div class="form-row">
            <label for="auth-email"><?php esc_html_e('Email or Mobile Number', 'authyo-otp-authentication-for-woocommerce'); ?></label>
            <input type="text" id="auth-email" name="email" required />
            <div id="auth-number-preview" class="number-preview"></div>
        </div>

        <div class="form-row">
            <button type="button" id="send-auth-otp"><?php esc_html_e('Send OTP', 'authyo-otp-authentication-for-woocommerce'); ?></button>
        </div>

        <div class="otp-fields">
            <div class="form-row">
                <label for="auth-otp"><?php esc_html_e('Enter OTP', 'authyo-otp-authentication-for-woocommerce'); ?></label>
                <input type="text" id="auth-otp" name="otp" maxlength="6" required />
                <input type="hidden" id="auth-mask-id" name="maskId" />
            </div>

            <button type="button" id="resend-auth-otp" class="button button-secondary resend-otp-btn" style="margin-top: 10px;">
                <span class="timer"><?php esc_html_e('Resend OTP', 'authyo-otp-authentication-for-woocommerce'); ?></span>
            </button>

            <div class="resend-otp-section authyo-hidden">
                <p class="resend-text"><?php esc_html_e('Didn\'t receive OTP? Try Resend OTP via:', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                <div class="resend-methods-grid">
                    <button type="button" class="resend-method-btn" data-method="sms">SMS</button>
                    <button type="button" class="resend-method-btn" data-method="whatsapp">WhatsApp</button>
                    <button type="button" class="resend-method-btn" data-method="voice">Voicecall</button>
                </div>
            </div>

            <div class="form-row">
                <button type="button" id="verify-auth-otp"><?php esc_html_e('Login', 'authyo-otp-authentication-for-woocommerce'); ?></button>
            </div>
        </div>

        <div id="auth-message" class="message"></div>
        </form>
    </div>
</div> 