<?php
/**
 * Notification Flow Page View
 *
 * @package Authyo_OTP_Auth
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$authyo_notification_flow = Authyo_Notification_Flow::get_instance();
$authyo_events = $authyo_notification_flow->get_woocommerce_events();
$authyo_methods = $authyo_notification_flow->get_notification_methods();
$authyo_saved_flows = $authyo_notification_flow->get_saved_flows();
?>

<div class="wrap authyo-modern-wrap authyo-notification-flow-wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="authyo-notification-flow-container">
        <div class="authyo-notification-flow-header">
            <div class="authyo-header-buttons-left">
                <button type="button" class="button button-primary" id="authyo-add-flow-btn">
                    <span class="dashicons dashicons-plus-alt"></span>
                    <?php esc_html_e('Add Flow', 'authyo-otp-authentication-for-woocommerce'); ?>
                </button>
            </div>
            <div class="authyo-header-buttons-right">
                <?php if (!empty($authyo_saved_flows)): ?>
                    <button type="button" class="button button-secondary" id="authyo-edit-all-flows-btn">
                        <span class="dashicons dashicons-edit"></span>
                        <?php esc_html_e('Edit All Flows', 'authyo-otp-authentication-for-woocommerce'); ?>
                    </button>
                    <button type="button" class="button button-secondary authyo-delete-all-btn" id="authyo-delete-all-flows-btn">
                        <span class="dashicons dashicons-trash"></span>
                        <?php esc_html_e('Delete All Flows', 'authyo-otp-authentication-for-woocommerce'); ?>
                    </button>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="authyo-notification-flow-content">
            <!-- Left Panel: Events -->
            <div class="authyo-notification-flow-left-panel">
                <h2 class="authyo-panel-title">
                    <?php esc_html_e('WooCommerce Events', 'authyo-otp-authentication-for-woocommerce'); ?>
                </h2>
                <ul class="authyo-events-list">
                    <?php foreach ($authyo_events as $authyo_event_key => $authyo_event_label): ?>
                        <?php
                        $authyo_has_flow = isset($authyo_saved_flows[$authyo_event_key]) && !empty($authyo_saved_flows[$authyo_event_key]['methods']);
                        ?>
                        <li class="authyo-event-item <?php echo $authyo_has_flow ? 'has-flow' : ''; ?>" data-event="<?php echo esc_attr($authyo_event_key); ?>">
                            <span class="authyo-event-name"><?php echo esc_html($authyo_event_label); ?></span>
                            <?php if ($authyo_has_flow): ?>
                                <span class="authyo-flow-indicator" title="<?php esc_attr_e('Has active flows', 'authyo-otp-authentication-for-woocommerce'); ?>">
                                    <span class="dashicons dashicons-yes-alt"></span>
                                </span>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            
            <!-- Right Panel: Templates -->
            <div class="authyo-notification-flow-right-panel">
                <h2 class="authyo-panel-title" id="authyo-panel-title">
                    <?php esc_html_e('Notification Templates', 'authyo-otp-authentication-for-woocommerce'); ?>
                </h2>
                <div class="authyo-templates-container">
                    <?php if (empty($authyo_saved_flows)): ?>
                        <div class="authyo-empty-state">
                            <p><?php esc_html_e('No notification flows configured yet.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                            <p><?php esc_html_e('Click "Add Flow" to create your first notification flow.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                        </div>
                    <?php else: ?>
                        <div class="authyo-flows-list">
                            <?php foreach ($authyo_saved_flows as $authyo_event_key => $authyo_flow): ?>
                                <?php
                                $authyo_event_label = isset($authyo_events[$authyo_event_key]) ? $authyo_events[$authyo_event_key] : $authyo_event_key;
                                $authyo_flow_methods = isset($authyo_flow['methods']) && is_array($authyo_flow['methods']) ? $authyo_flow['methods'] : array();
                                if (empty($authyo_flow_methods)) {
                                    continue;
                                }
                                ?>
                                <?php
                                $authyo_is_enabled = !isset($authyo_flow['enabled']) || $authyo_flow['enabled'] !== false; // Default to enabled for backward compatibility
                                ?>
                                <div class="authyo-flow-item <?php echo $authyo_is_enabled ? '' : 'authyo-flow-disabled'; ?>" data-event="<?php echo esc_attr($authyo_event_key); ?>">
                                    <div class="authyo-flow-header">
                                        <div class="authyo-flow-info">
                                            <label class="authyo-toggle-switch">
                                                <input type="checkbox" 
                                                       class="authyo-flow-toggle" 
                                                       data-event="<?php echo esc_attr($authyo_event_key); ?>"
                                                       <?php checked($authyo_is_enabled, true); ?> />
                                                <span class="authyo-toggle-slider"></span>
                                            </label>
                                            <span class="authyo-flow-event"><?php echo esc_html($authyo_event_label); ?></span>
                                            <span class="authyo-flow-separator">→</span>
                                            <div class="authyo-flow-methods">
                                                <?php
                                                $authyo_method_labels = array();
                                                foreach ($authyo_flow_methods as $authyo_method_key) {
                                                    if (isset($authyo_methods[$authyo_method_key])) {
                                                        $authyo_method_labels[] = esc_html($authyo_methods[$authyo_method_key]);
                                                    }
                                                }
                                                echo esc_html(implode(', ', $authyo_method_labels));
                                                ?>
                                            </div>
                                        </div>
                                        <div class="authyo-flow-actions">
                                            <button type="button" class="authyo-edit-flow-btn" data-event="<?php echo esc_attr($authyo_event_key); ?>" title="<?php esc_attr_e('Edit Flow', 'authyo-otp-authentication-for-woocommerce'); ?>">
                                                <span class="dashicons dashicons-edit"></span>
                                            </button>
                                            <button type="button" class="authyo-delete-flow-btn" data-event="<?php echo esc_attr($authyo_event_key); ?>" title="<?php esc_attr_e('Delete Flow', 'authyo-otp-authentication-for-woocommerce'); ?>">
                                                <span class="dashicons dashicons-trash"></span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="authyo-flow-template">
                                        <?php
                                        // Get template name for this event
                                        $authyo_template_name = authyo_get_template_for_event($authyo_event_key);
                                        
                                        if (!empty($authyo_template_name)) {
                                            if ($authyo_template_name === 'coming_soon') {
                                                // Show "Coming Soon" for templates under development
                                                $authyo_template_display = __('Coming Soon', 'authyo-otp-authentication-for-woocommerce');
                                                $authyo_template_class = 'authyo-template-coming-soon';
                                            } else {
                                                // Format template name: order_placed -> Order Placed
                                                $authyo_template_display = ucwords(str_replace('_', ' ', $authyo_template_name));
                                                $authyo_template_class = 'authyo-template-name';
                                            }
                                        } else {
                                            $authyo_template_display = __('No template assigned', 'authyo-otp-authentication-for-woocommerce');
                                            $authyo_template_class = 'authyo-template-placeholder';
                                        }
                                        ?>
                                        <p class="<?php echo esc_attr($authyo_template_class); ?>">
                                            <strong><?php esc_html_e('Template:', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                                            <span><?php echo esc_html($authyo_template_display); ?></span>
                                            <?php if ($authyo_template_class === 'authyo-template-name'): ?>
                                                <a href="https://authyo.io/template" target="_blank" rel="noopener noreferrer" style="margin-left: 10px;">
                                                    <?php esc_html_e('To view these templates, click here.', 'authyo-otp-authentication-for-woocommerce'); ?>
                                                </a>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Flow Popup -->
<?php include_once AUTHYO_OTP_AUTH_PLUGIN_DIR . 'modules/notification-flow/views/add-flow-popup.php'; ?>

<!-- Edit All Flows Popup -->
<?php include_once AUTHYO_OTP_AUTH_PLUGIN_DIR . 'modules/notification-flow/views/edit-all-flows-popup.php'; ?>
