<?php
/**
 * Add Flow Popup View
 *
 * @package Authyo_OTP_Auth
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$authyo_notification_flow = Authyo_Notification_Flow::get_instance();
$authyo_events = $authyo_notification_flow->get_woocommerce_events();
$authyo_methods = $authyo_notification_flow->get_notification_methods();
?>

<div id="authyo-add-flow-popup" class="authyo-popup-overlay" style="display: none;">
    <div class="authyo-popup-content">
        <div class="authyo-popup-header">
            <h2 id="authyo-popup-title"><?php esc_html_e('Add Notification Flow', 'authyo-otp-authentication-for-woocommerce'); ?></h2>
            <button type="button" class="authyo-popup-close" id="authyo-close-popup">
                <span class="dashicons dashicons-no-alt"></span>
            </button>
        </div>
        
        <div class="authyo-popup-body">
            <form id="authyo-add-flow-form">
                <input type="hidden" id="authyo-flow-mode" name="mode" value="add" />
                <input type="hidden" id="authyo-flow-edit-event" name="edit_event" value="" />
                
                <div class="authyo-form-field">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 12px;">
                        <label style="margin: 0;">
                            <?php esc_html_e('WooCommerce Events', 'authyo-otp-authentication-for-woocommerce'); ?>
                            <span class="required">*</span>
                        </label>
                        <button type="button" class="button button-link" id="authyo-select-all-events-btn" style="padding: 0; height: auto; font-size: 13px;">
                            <?php esc_html_e('Select All Events', 'authyo-otp-authentication-for-woocommerce'); ?>
                        </button>
                    </div>
                    <p class="description" style="margin-bottom: 12px;">
                        <?php esc_html_e('Select one or more WooCommerce events. For each selected event, choose the notification methods below.', 'authyo-otp-authentication-for-woocommerce'); ?>
                    </p>
                    
                    <div class="authyo-select-all-methods-container" style="display: none; margin-bottom: 12px; padding: 10px; background: #f0f6fc; border-radius: 4px; border-left: 3px solid #2271b1;">
                        <button type="button" class="button button-link" id="authyo-select-all-methods-btn" style="padding: 0; height: auto; font-size: 13px; color: #2271b1; font-weight: 500;">
                            <?php esc_html_e('Select All Notification Methods', 'authyo-otp-authentication-for-woocommerce'); ?>
                        </button>
                        <span style="font-size: 12px; color: #646970; margin-left: 8px;">
                            <?php esc_html_e('(Applies to all selected events)', 'authyo-otp-authentication-for-woocommerce'); ?>
                        </span>
                    </div>
                    
                    <div class="authyo-events-accordion">
                        <?php foreach ($authyo_events as $authyo_event_key => $authyo_event_label): ?>
                            <div class="authyo-event-accordion-item" data-event="<?php echo esc_attr($authyo_event_key); ?>">
                                <div class="authyo-event-accordion-header">
                                    <label class="authyo-checkbox-label">
                                        <input type="checkbox" 
                                               name="events[]" 
                                               value="<?php echo esc_attr($authyo_event_key); ?>" 
                                               class="authyo-event-checkbox" 
                                               data-event="<?php echo esc_attr($authyo_event_key); ?>" />
                                        <span class="authyo-checkbox-text">
                                            <strong><?php echo esc_html($authyo_event_label); ?></strong>
                                        </span>
                                    </label>
                                </div>
                                <div class="authyo-event-accordion-content">
                                    <label class="authyo-methods-label">
                                        <?php esc_html_e('Notification Methods', 'authyo-otp-authentication-for-woocommerce'); ?>
                                        <span class="required">*</span>
                                    </label>
                                    <div class="authyo-methods-checkbox-group" data-event="<?php echo esc_attr($authyo_event_key); ?>">
                                        <?php foreach ($authyo_methods as $authyo_method_key => $authyo_method_label): ?>
                                            <label class="authyo-checkbox-label">
                                                <input type="checkbox" 
                                                       name="methods[<?php echo esc_attr($authyo_event_key); ?>][]" 
                                                       value="<?php echo esc_attr($authyo_method_key); ?>" 
                                                       class="authyo-method-checkbox" 
                                                       data-event="<?php echo esc_attr($authyo_event_key); ?>" />
                                                <span class="authyo-checkbox-text">
                                                    <strong><?php echo esc_html($authyo_method_label); ?></strong>
                                                </span>
                                            </label>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <div class="authyo-form-actions">
                    <button type="button" class="button button-secondary" id="authyo-cancel-flow-btn">
                        <?php esc_html_e('Cancel', 'authyo-otp-authentication-for-woocommerce'); ?>
                    </button>
                    <button type="submit" class="button button-primary" id="authyo-save-flow-btn">
                        <span id="authyo-save-btn-text"><?php esc_html_e('Save Flow', 'authyo-otp-authentication-for-woocommerce'); ?></span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
