<?php
/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 *
 * @link              https://authyo.io/
 * @since             1.0.0
 * @package           Authyo_OTP_Auth
 * @subpackage        Authyo_OTP_Auth/includes
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin.
 *
 * Since WordPress 4.6, translations are automatically loaded for plugins
 * hosted on WordPress.org, so manual loading is no longer required.
 *
 * @since             1.0.0
 * @package           Authyo_OTP_Auth
 * @subpackage        Authyo_OTP_Auth/includes
 */
class Authyo_OTP_Auth_i18n {

    /**
     * Initialize internationalization functionality.
     *
     * Note: Since WordPress 4.6, load_plugin_textdomain() is automatically
     * handled by WordPress for plugins hosted on WordPress.org.
     *
     * @since    1.0.0
     */
    public function load_plugin_textdomain() {
        // WordPress 4.6+ automatically loads translations for plugins
        // hosted on WordPress.org. No manual loading is required.
        // 
        // For development or custom installations, uncomment the following:
        /*
        load_plugin_textdomain(
            'authyo-otp-authentication-for-woocommerce',
            false,
            dirname(dirname(plugin_basename(__FILE__))) . '/languages/'
        );
        */
    }

} 