<?php
/**
 * Documentation page for Authyo OTP Auth
 */

if (!defined('ABSPATH')) {
    exit;
}

class Authyo_OTP_Auth_Docs {
    private static $instance = null;
    private $version;

    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
        $this->version = AUTHYO_OTP_AUTH_VERSION;
        add_action('admin_menu', array($this, 'add_docs_menu'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_docs_scripts'));
    }

    public function add_docs_menu() {
        add_submenu_page(
            'authyo-otp-authentication-for-woocommerce',
            esc_html__('Documentation', 'authyo-otp-authentication-for-woocommerce'),
            esc_html__('Documentation', 'authyo-otp-authentication-for-woocommerce'),
            'manage_options',
            'authyo-otp-authentication-for-woocommerce-docs',
            array($this, 'render_documentation_page')
        );
    }

    public function enqueue_docs_scripts($hook) {
        // Only load on plugin docs page
        if ($hook !== 'authyo-otp-authentication-for-woocommerce_page_authyo-otp-authentication-for-woocommerce-docs') {
            return;
        }

        wp_enqueue_style(
            'authyo-otp-authentication-for-woocommerce-docs',
            plugin_dir_url(__FILE__) . '../assets/css/docs.css',
            array(),
            $this->version
        );
    }

    public function render_documentation_page() {
        ?>
        <div class="wrap authyo-modern-wrap">
            <h1><?php esc_html_e('Authyo OTP Auth Documentation', 'authyo-otp-authentication-for-woocommerce'); ?></h1>
            
            <div class="authyo-docs-grid">
                <div class="authyo-otp-docs-section">
                    <h2><?php esc_html_e('Initial Setup', 'authyo-otp-authentication-for-woocommerce'); ?></h2>
                    <ol>
                        <li>
                            <strong><?php esc_html_e('Install and Activate', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                            <p><?php esc_html_e('Install and activate the Authyo OTP Auth plugin from your WordPress admin panel.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Configure Settings', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                            <p><?php esc_html_e('Go to WooCommerce > OTP Auth Settings to configure your Authyo service and define OTP behavior.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                            <p><?php esc_html_e('The settings page includes the following sections:', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                            <ul>
                                <li>
                                    <strong><?php esc_html_e('Keys', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                                    <p><?php echo wp_kses(__('You will need to sign up at <a href="https://authyo.io/account/welcome?utm_source=plugin-authyo-otp-authentication-for-woocommerce
" target="_blank">Authyo.io</a> to generate these keys.', 'authyo-otp-authentication-for-woocommerce'), array('a' => array('href' => array(), 'target' => array()))); ?></p>
                                    <ul>
                                        <li><?php esc_html_e('Authyo App ID: Your unique application identifier.', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                        <li><?php esc_html_e('Authyo Client ID: Your client identifier.', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                        <li><?php esc_html_e('Authyo Client Secret: Your secret key for authentication.', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                    </ul>
                                </li>
                                <li>
                                    <strong><?php esc_html_e('Enable OTP Options', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                                    <p><?php esc_html_e('Check these options to enable OTP verification for different actions:', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                                    <ul>
                                        <li><?php esc_html_e('Enable OTP on Login: Requires OTP verification during login.', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                        <li><?php esc_html_e('Enable OTP on Registration: Requires OTP verification during registration.', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                    </ul>
                                </li>
                                <li>
                                    <strong><?php esc_html_e('OTP Configuration', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                                    <p><?php esc_html_e('Set the parameters for the generated OTP:', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                                    <ul>
                                        <li><?php esc_html_e('OTP Length: Number of digits in the OTP (typically between 4 and 8). Default is 6.', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                        <li><?php esc_html_e('OTP Expiry: Time in seconds before the OTP expires. Default is 300 seconds (5 minutes).', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                    </ul>
                                </li>
                                <li>
                                    <strong><?php esc_html_e('OTP Delivery Methods', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                                    <p><?php esc_html_e('Select the methods you want to enable for sending the OTP to the user.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                                    <ul>
                                        <li><?php esc_html_e('Send OTP via Email', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                        <li><?php esc_html_e('Send OTP via WhatsApp', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                        <li><?php esc_html_e('Send OTP via SMS', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                        <li><?php esc_html_e('Send OTP via Voice Call', 'authyo-otp-authentication-for-woocommerce'); ?></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                    </ol>
                </div>

                <div class="authyo-otp-docs-section">
                    <h2><?php esc_html_e('Shortcodes', 'authyo-otp-authentication-for-woocommerce'); ?></h2>
                    <div class="authyo-otp-docs-shortcode">
                        <h3><?php esc_html_e('Login Form', 'authyo-otp-authentication-for-woocommerce'); ?></h3>
                        <code>[authyo_otp_login]</code>
                        <p><?php esc_html_e('Use this shortcode to display the OTP login form on any page.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                    </div>
                    <div class="authyo-otp-docs-shortcode">
                        <h3><?php esc_html_e('Registration Form', 'authyo-otp-authentication-for-woocommerce'); ?></h3>
                        <code>[authyo_otp_register]</code>
                        <p><?php esc_html_e('Use this shortcode to display the OTP registration form on any page.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                    </div>
                </div>

                <div class="authyo-otp-docs-section">
                    <h2><?php esc_html_e('Features', 'authyo-otp-authentication-for-woocommerce'); ?></h2>
                    <ul>
                        <li>
                            <strong><?php esc_html_e('Mobile & Email Login', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                            <p><?php esc_html_e('Users can login using either their mobile number or email address.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                        </li>
                        <li>
                            <strong><?php esc_html_e('OTP Verification', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                            <p><?php esc_html_e('Secure one-time password verification for both login and registration.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Mobile Number Management', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                            <p><?php esc_html_e('Users can manage their mobile numbers in their WooCommerce account.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                        </li>
                    </ul>
                </div>

                <div class="authyo-otp-docs-section">
                    <h2><?php esc_html_e('Troubleshooting', 'authyo-otp-authentication-for-woocommerce'); ?></h2>
                    <div class="authyo-otp-docs-troubleshooting">
                        <h3><?php esc_html_e('Common Issues', 'authyo-otp-authentication-for-woocommerce'); ?></h3>
                        <ul>
                            <li>
                                <strong><?php esc_html_e('OTP Not Received', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                                <p><?php esc_html_e('Check your API key configuration and ensure the mobile number/email is correct.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                            </li>
                            <li>
                                <strong><?php esc_html_e('Login Issues', 'authyo-otp-authentication-for-woocommerce'); ?></strong>
                                <p><?php esc_html_e('Verify that the user exists in the database and has a valid mobile number or email.', 'authyo-otp-authentication-for-woocommerce'); ?></p>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
} 