<?php
if (!defined('ABSPATH')) {
    exit;
}

class Authyo_OTP_Auth_Activator {
    public static function activate() {
        global $wpdb;

        $table_name = $wpdb->prefix . 'authyo_otp_auth_logs';

        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE $table_name (
            id int(11) NOT NULL AUTO_INCREMENT,
            email varchar(255) NOT NULL,
            otp varchar(10) NOT NULL,
            status varchar(50) NOT NULL,
            ip_address varchar(45) NOT NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            user_id int(11) DEFAULT 0,
            PRIMARY KEY (id)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        // Set default options
        $default_settings = array(
            'enable_login' => 'yes',
            'enable_registration' => 'yes',
            'email_enabled' => 'yes',
            'whatsapp_enabled' => 'no',
            'sms_enabled' => 'no',
            'voice_enabled' => 'no',
            'length' => 6,
            'expiry' => 300,
            'app_id' => '',
            'client_id' => '',
            'client_secret' => ''
        );

        if (!get_option('authyo_otp_auth_settings')) {
            update_option('authyo_otp_auth_settings', $default_settings);
        }
        
        // Enable fallback methods by default for better user experience
        if (!get_option('authyo_otp_auth_fallback_enabled')) {
            update_option('authyo_otp_auth_fallback_enabled', 'yes');
        }
        if (!get_option('authyo_otp_auth_sms_enabled')) {
            update_option('authyo_otp_auth_sms_enabled', 'yes');
        }
        if (!get_option('authyo_otp_auth_whatsapp_enabled')) {
            update_option('authyo_otp_auth_whatsapp_enabled', 'yes');
        }
        if (!get_option('authyo_otp_auth_voice_enabled')) {
            update_option('authyo_otp_auth_voice_enabled', 'yes');
        }
        
        // Set reasonable OTP expiry (60 seconds instead of 300 for better UX)
        if (!get_option('authyo_otp_auth_expiry')) {
            update_option('authyo_otp_auth_expiry', '60');
        }
        if (!get_option('authyo_otp_auth_length')) {
            update_option('authyo_otp_auth_length', '6');
        }

        // No need to create custom database columns - using WooCommerce's billing_phone field
    }
} 