jQuery(document).ready(function($) {
    // Common functions
    function showMessage(element, message, type = 'error') {
        element.removeClass('success error').addClass(type).html(message).show();
        setTimeout(() => element.fadeOut(), 5000);
    }

    function toggleOTPFields(form, show = true) {
        form.find('.otp-fields').toggle(show);
        form.find('.password-fields').toggle(!show);
    }

    function validateEmail(email) {
        return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
    }

    // Registration Form Handler
    $('.authyo-otp-register-form').each(function() {
        const form = $(this);
        
        // Skip forms that have specialized handlers (register-form.js)
        if (form.attr('id') === 'authyo-otp-authentication-for-woocommerce-register-form') {
            return; // Skip this form, it's handled by register-form.js
        }
        
        const messageDiv = form.find('.authyo-otp-auth-message');
        const emailInput = form.find('input[name="email"]');
        const sendOtpBtn = form.find('.send-otp-button');
        const verifyOtpBtn = form.find('.verify-otp-button');
        const otpInput = form.find('input[name="otp"]');
        const resendOtpBtn = form.find('#resend-register-otp');
        const passwordInput = form.find('input[name="password"]');
        const initialFields = form.find('.initial-fields');
        const otpFields = form.find('.otp-fields');
        var timerInterval;
        var timeLeft = 300; // 5 minutes in seconds

        function startTimer() {
            timeLeft = authyoOtpAuth.otpExpiry; // Use configured expiry time
            resendOtpBtn.prop('disabled', true);
            updateTimerDisplay();
            
            clearInterval(timerInterval);
            timerInterval = setInterval(function() {
                timeLeft--;
                updateTimerDisplay();
                
                if (timeLeft <= 0) {
                    clearInterval(timerInterval);
                    resendOtpBtn.prop('disabled', false).find('.timer').text('Resend OTP');
                }
            }, 1000);
        }

        function updateTimerDisplay() {
            var minutes = Math.floor(timeLeft / 60);
            var seconds = timeLeft % 60;
            resendOtpBtn.find('.timer').text('Resend OTP (' + minutes + ':' + (seconds < 10 ? '0' : '') + seconds + 's)');
        }

        // Send OTP Button Click Handler
        sendOtpBtn.on('click', function(e) {
            e.preventDefault();
            const email = emailInput.val().trim();

            // Check if input is email or mobile
            const isEmail = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
            const cleanMobile = email.replace(/\D/g, '');
            const isMobile = email.startsWith('+') ? 
                (cleanMobile.length >= 10 && /^\d+$/.test(cleanMobile)) : 
                (cleanMobile.length >= 10 && cleanMobile.length <= 15 && /^\d+$/.test(cleanMobile));
            
            if (!isEmail && !isMobile) {
                showMessage(messageDiv, 'Please enter a valid email or mobile number');
                return false;
            }

            // Add + prefix to mobile number if it's a mobile number
            const processedEmail = isMobile ? 
                (email.startsWith('+') ? email.replace(/[^\d+]/g, '') : '+' + email.replace(/\D/g, '')) : 
                email;

            // Update button state
            sendOtpBtn.prop('disabled', true).text('Sending...');

            // Make AJAX request to send OTP
            $.post(authyoOtpAuth.ajaxurl, {
                action: 'send_register_otp',
                email: processedEmail,
                is_mobile: isMobile,
                authyo_otp_auth_nonce: authyoOtpAuth.nonce
            })
            .done(function(response) {
                if (response.success) {
                    showMessage(messageDiv, response.data.message, 'success');
                    form.find('input[name="mask_id"]').val(response.data.maskId);
                    initialFields.hide();
                    otpFields.show();
                    startTimer();
                } else {
                    showMessage(messageDiv, response.data.message || 'Failed to send OTP');
                }
            })
            .fail(function() {
                showMessage(messageDiv, 'Failed to send OTP. Please try again.');
            })
            .always(function() {
                sendOtpBtn.prop('disabled', false).text('Send OTP');
            });
        });

        // Resend OTP Button Click Handler
        resendOtpBtn.on('click', function() {
            const email = emailInput.val().trim();
            
            if (!email) {
                showMessage(messageDiv, 'Please enter your email or mobile number');
                return;
            }

            const isEmail = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
            const cleanMobile = email.replace(/\D/g, '');
            const isMobile = email.startsWith('+') ? 
                (cleanMobile.length >= 10 && /^\d+$/.test(cleanMobile)) : 
                (cleanMobile.length >= 10 && cleanMobile.length <= 15 && /^\d+$/.test(cleanMobile));

            if (!isEmail && !isMobile) {
                showMessage(messageDiv, 'Please enter a valid email or mobile number');
                return;
            }

            resendOtpBtn.prop('disabled', true);

            $.post(authyoOtpAuth.ajaxurl, {
                action: 'send_register_otp',
                email: email,
                is_mobile: isMobile,
                authyo_otp_auth_nonce: authyoOtpAuth.nonce
            })
            .done(function(response) {
                if (response.success) {
                    form.find('input[name="mask_id"]').val(response.data.maskId);
                    showMessage(messageDiv, response.data.message, 'success');
                    startTimer();
                } else {
                    showMessage(messageDiv, response.data.message || 'Failed to send OTP');
                    resendOtpBtn.prop('disabled', false);
                }
            })
            .fail(function() {
                showMessage(messageDiv, 'Failed to send OTP. Please try again.');
                resendOtpBtn.prop('disabled', false);
            });
        });

        // Form Submit Handler (OTP Verification)
        form.on('submit', function(e) {
            e.preventDefault();
            
            const otp = otpInput.val().trim();
            const maskId = form.find('input[name="mask_id"]').val();
            const email = emailInput.val().trim();
            const cleanMobile = email.replace(/\D/g, '');
            const isMobile = email.startsWith('+') ? 
                (cleanMobile.length >= 10 && /^\d+$/.test(cleanMobile)) : 
                (cleanMobile.length >= 10 && cleanMobile.length <= 15 && /^\d+$/.test(cleanMobile));

            if (!otp) {
                showMessage(messageDiv, 'Please enter the OTP');
                return;
            }

            verifyOtpBtn.prop('disabled', true).text('Verifying...');

            // Verify OTP
            $.post(authyoOtpAuth.ajaxurl, {
                action: 'verify_register_otp',
                email: email,
                otp: otp,
                maskId: maskId,
                is_mobile: isMobile,
                authyo_otp_auth_nonce: authyoOtpAuth.nonce
            })
            .done(function(response) {
                if (response.success) {
                    showMessage(messageDiv, response.data.message, 'success');
                    if (response.data.redirect) {
                        window.location.href = response.data.redirect;
                    } else {
                        window.location.href = authyoOtpAuth.myAccountUrl;
                    }
                } else {
                    showMessage(messageDiv, (response.data && response.data.message) || 'Failed to verify OTP');
                }
            })
            .fail(function(jqXHR) {
                let errorMsg = 'Failed to verify OTP. Please try again.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.data) {
                    errorMsg = jqXHR.responseJSON.data.message;
                }
                showMessage(messageDiv, errorMsg);
            })
            .always(function() {
                verifyOtpBtn.prop('disabled', false).text('Create Account');
            });
        });

        if (form.find('input[name="mask_id"]').val()) {
            initialFields.hide();
            otpFields.show();
        }
    });

    // Login Form Handler
    $('.authyo-otp-login-form').each(function() {
        const form = $(this);
        
        // Skip forms that have specialized handlers (login-form.js)
        if (form.attr('id') === 'authyo-otp-authentication-for-woocommerce-login-form') {
            return; // Skip this form, it's handled by login-form.js
        }
        
        const messageDiv = form.find('.authyo-otp-auth-message');
        const emailInput = form.find('input[name="email"]');
        const sendOtpBtn = form.find('.send-otp-button');
        const verifyOtpBtn = form.find('.verify-otp-button');
        const otpInput = form.find('input[name="otp"]');
        const initialFields = form.find('.initial-fields');
        const otpFields = form.find('.otp-fields');
        var timerInterval;
        var timeLeft = authyoOtpAuth.otpExpiry; // Use configured expiry time

        function startTimer() {
            timeLeft = authyoOtpAuth.otpExpiry; // Use configured expiry time
            resendOtpBtn.prop('disabled', true);
            updateTimerDisplay();
            
            clearInterval(timerInterval);
            timerInterval = setInterval(function() {
                timeLeft--;
                updateTimerDisplay();
                
                if (timeLeft <= 0) {
                    clearInterval(timerInterval);
                    resendOtpBtn.prop('disabled', false).find('.timer').text('Resend OTP');
                }
            }, 1000);
        }

        function updateTimerDisplay() {
            var minutes = Math.floor(timeLeft / 60);
            var seconds = timeLeft % 60;
            resendOtpBtn.find('.timer').text('Resend OTP (' + minutes + ':' + (seconds < 10 ? '0' : '') + seconds + 's)');
        }

        // Send OTP Button Click Handler
        sendOtpBtn.on('click', function(e) {
            e.preventDefault();
            const email = emailInput.val().trim();

            if (!email) {
                showMessage(messageDiv, 'Please enter a valid email address');
                return;
            }

            // Check if input is email or mobile
            const isEmail = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
            const cleanMobile = email.replace(/\D/g, '');
            const isMobile = email.startsWith('+') ? 
                (cleanMobile.length >= 10 && /^\d+$/.test(cleanMobile)) : 
                (cleanMobile.length >= 10 && cleanMobile.length <= 15 && /^\d+$/.test(cleanMobile));

            if (!isEmail && !isMobile) {
                showMessage(messageDiv, 'Please enter a valid email or mobile number');
                return;
            }

            // Add + prefix to mobile number if it's a mobile number
            const processedEmail = isMobile ? 
                (email.startsWith('+') ? email.replace(/[^\d+]/g, '') : '+' + email.replace(/\D/g, '')) : 
                email;

            sendOtpBtn.prop('disabled', true).text('Sending...');

            // Login form AJAX
            $.post(authyoOtpAuth.ajaxurl, {
                action: 'send_login_otp',
                email: processedEmail,
                is_mobile: isMobile,
                authyo_otp_auth_nonce: authyoOtpAuth.nonce
            })
            .done(function(response) {
                if (response.success && response.data && response.data.maskId) {
                    showMessage(messageDiv, response.data.message, 'success');
                    form.find('input[name="mask_id"]').val(response.data.maskId);
                    initialFields.hide();
                    otpFields.show();
                } else {
                    showMessage(messageDiv, (response.data && response.data.message) || 'Failed to send OTP');
                }
            })
            .fail(function(jqXHR) {
                let errorMsg = 'Failed to send OTP. Please try again.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.data) {
                    errorMsg = jqXHR.responseJSON.data.message;
                }
                showMessage(messageDiv, errorMsg);
            })
            .always(function() {
                sendOtpBtn.prop('disabled', false).text('Send OTP');
            });
        });

        // Form Submit Handler (OTP Verification)
        form.on('submit', function(e) {
            e.preventDefault();
            
            const otp = otpInput.val().trim();
            const maskId = form.find('input[name="mask_id"]').val();
            const email = emailInput.val().trim();

            if (!otp) {
                showMessage(messageDiv, 'Please enter the OTP');
                return;
            }

            verifyOtpBtn.prop('disabled', true).text('Verifying...');

            // Verify OTP
            $.post(authyoOtpAuth.ajaxurl, {
                action: 'handle_login_form',
                email: email,
                otp: otp,
                maskId: maskId,
                _wpnonce: authyoOtpAuth.nonce,
                authyo_otp_auth_nonce: authyoOtpAuth.nonce
            })
            .done(function(response) {
                if (response.success) {
                    // Redirect immediately without showing message
                    if (response.data.redirect) {
                        window.location.replace(response.data.redirect);
                    } else {
                        window.location.replace(authyoOtpAuth.myAccountUrl);
                    }
                } else {
                    showMessage(messageDiv, (response.data && response.data.message) || 'Failed to verify OTP');
                }
            })
            .fail(function(jqXHR) {
                let errorMsg = 'Failed to verify OTP. Please try again.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.data) {
                    errorMsg = jqXHR.responseJSON.data.message;
                }
                showMessage(messageDiv, errorMsg);
            })
            .always(function() {
                verifyOtpBtn.prop('disabled', false).text('Login');
            });
        });

        if (form.find('input[name="mask_id"]').val()) {
            initialFields.hide();
            otpFields.show();
        }
    });

    // Forgot Password Form Handler
    $('.authyo-otp-forgot-form').each(function() {
        const form = $(this);
        const messageDiv = form.find('.authyo-otp-auth-message');
        const emailInput = form.find('input[name="email"]');
        const sendOtpBtn = form.find('.send-otp-button');
        const verifyOtpBtn = form.find('.verify-otp-button');
        const otpInput = form.find('input[name="otp"]');
        const passwordInput = form.find('input[name="new_password"]');
        const initialFields = form.find('.initial-fields');
        const otpFields = form.find('.otp-fields');

        // Send OTP Button Click Handler
        sendOtpBtn.on('click', function(e) {
            e.preventDefault();
            const email = emailInput.val().trim();

            // if (!email || !validateEmail(email)) {
            //     showMessage(messageDiv, 'Please enter a valid email address');
            //     return;
            // }

            sendOtpBtn.prop('disabled', true).text('Sending...');

            // Forgot password form AJAX
            $.post(authyoOtpAuth.ajaxurl, {
                action: 'send_forgot_otp',
                email: email,
                authyo_otp_auth_nonce: authyoOtpAuth.nonce
            })
            .done(function(response) {
                if (response.success) {
                    showMessage(messageDiv, response.data.message, 'success');
                    form.find('input[name="mask_id"]').val(response.data.maskId);
                    initialFields.hide();
                    otpFields.show();
                } else {
                    showMessage(messageDiv, response.data.message || 'Failed to send OTP');
                }
            })
            .fail(function() {
                showMessage(messageDiv, 'Failed to send OTP. Please try again.');
            })
            .always(function() {
                sendOtpBtn.prop('disabled', false).text('Send OTP');
            });
        });

        // Form Submit Handler (OTP Verification)
        form.on('submit', function(e) {
            e.preventDefault();
            
            const otp = otpInput.val().trim();
            const maskId = form.find('input[name="mask_id"]').val();
            const email = emailInput.val().trim();

            if (!otp) {
                showMessage(messageDiv, 'Please enter the OTP');
                return;
            }

            verifyOtpBtn.prop('disabled', true).text('Verifying...');

            $.get(authyoOtpAuth.ajaxurl, {
                action: 'verify_forgot_otp',
                email: email,
                otp: otp,
                maskId: maskId,
                authyo_otp_nonce: authyoOtpAuth.nonce,
                authyo_otp_auth_nonce: authyoOtpAuth.nonce
            })
            .done(function(response) {
                if (response.success) {
                    showMessage(messageDiv, response.data.message, 'success');
                    if (response.data.redirect) {
                        window.location.href = response.data.redirect;
                    } else {
                        window.location.href = authyoOtpAuth.loginUrl;
                    }
                } else {
                    showMessage(messageDiv, response.data.message || 'Failed to verify OTP');
                }
            })
            .fail(function() {
                showMessage(messageDiv, 'Failed to verify OTP. Please try again.');
            })
            .always(function() {
                verifyOtpBtn.prop('disabled', false).text('Reset Password');
            });
        });

        if (form.find('input[name="mask_id"]').val()) {
            initialFields.hide();
            otpFields.show();
        }
    });

    // Show success/error messages if they exist (from server-side)
    $('.authyo-otp-auth-message').each(function() {
        const message = $(this);
        if (message.text().trim() !== '') {
            message.show();
            setTimeout(() => message.fadeOut(), 5000);
        }
    });
}); 