jQuery(document).ready(function($) {
    'use strict';
    
    // Check if the admin object exists
    if (typeof authyoOtpAuthAdmin === 'undefined') {
        return;
    }
    
    // Bulk delete functionality for logs
    $('#bulk-delete-logs').on('click', function(e) {
        e.preventDefault();
        
        var selectedLogs = [];
        $('input[name="log_ids[]"]:checked').each(function() {
            selectedLogs.push($(this).val());
        });
        
        if (selectedLogs.length === 0) {
            alert('Please select at least one log to delete.');
            return;
        }
        
        if (!confirm(authyoOtpAuthAdmin.messages.confirm_delete)) {
            return;
        }
        
        var $button = $(this);
        var originalText = $button.text();
        
        $button.prop('disabled', true).text('Deleting...');
        
        $.post(authyoOtpAuthAdmin.ajaxurl, {
            action: 'authyo_otp_auth_bulk_delete_logs',
            log_ids: selectedLogs,
            nonce: authyoOtpAuthAdmin.nonce
        })
        .done(function(response) {
            if (response.success) {
                // Reload the page to reflect changes
                location.reload();
            } else {
                alert(response.data.message || authyoOtpAuthAdmin.messages.delete_error);
            }
        })
        .fail(function() {
            alert(authyoOtpAuthAdmin.messages.delete_error);
        })
        .always(function() {
            $button.prop('disabled', false).text(originalText);
        });
    });
    
    // Select all/none functionality
    $('#select-all-logs').on('change', function() {
        $('input[name="log_ids[]"]').prop('checked', $(this).prop('checked'));
    });
    
    // Update select all checkbox when individual checkboxes change
    $('input[name="log_ids[]"]').on('change', function() {
        var total = $('input[name="log_ids[]"]').length;
        var checked = $('input[name="log_ids[]"]:checked').length;
        
        $('#select-all-logs').prop('indeterminate', checked > 0 && checked < total);
        $('#select-all-logs').prop('checked', checked === total);
    });
    
    // Settings form validation
    $('#authyo-otp-auth-settings-form').on('submit', function(e) {
        var apiKey = $('#authyo_otp_auth_api_key').val().trim();
        var secretKey = $('#authyo_otp_auth_secret_key').val().trim();
        
        if (!apiKey || !secretKey) {
            e.preventDefault();
            alert('Please enter both API Key and Secret Key.');
            return false;
        }
    });
    
    // API key visibility toggle
    $('.toggle-api-key').on('click', function(e) {
        e.preventDefault();
        var $input = $(this).siblings('input');
        var $icon = $(this).find('i');
        
        if ($input.attr('type') === 'password') {
            $input.attr('type', 'text');
            $icon.removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            $input.attr('type', 'password');
            $icon.removeClass('fa-eye-slash').addClass('fa-eye');
        }
    });
    
    // Test API connection
    $('#test-api-connection').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var originalText = $button.text();
        
        $button.prop('disabled', true).text('Testing...');
        
        $.post(authyoOtpAuthAdmin.ajaxurl, {
            action: 'authyo_otp_auth_test_connection',
            api_key: $('#authyo_otp_auth_api_key').val(),
            secret_key: $('#authyo_otp_auth_secret_key').val(),
            nonce: authyoOtpAuthAdmin.nonce
        })
        .done(function(response) {
            if (response.success) {
                $('.api-test-result').html('<div class="notice notice-success"><p>' + response.data.message + '</p></div>');
            } else {
                $('.api-test-result').html('<div class="notice notice-error"><p>' + response.data.message + '</p></div>');
            }
        })
        .fail(function() {
            $('.api-test-result').html('<div class="notice notice-error"><p>Connection test failed. Please try again.</p></div>');
        })
        .always(function() {
            $button.prop('disabled', false).text(originalText);
        });
    });
    
    // Clear country codes cache
    $('#clear-country-codes-cache').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $message = $('#cache-clear-message');
        var originalText = $button.text();
        
        $button.prop('disabled', true).text('Clearing...');
        $message.text('');
        
        $.post(authyoOtpAuthAdmin.ajaxurl, {
            action: 'clear_country_codes_cache',
            nonce: authyoOtpAuthAdmin.nonce
        })
        .done(function(response) {
            if (response.success) {
                $message.html('<span style="color: green;">✓ ' + response.data.message + '</span>');
            } else {
                $message.html('<span style="color: red;">✗ ' + (response.data.message || 'Error clearing cache') + '</span>');
            }
        })
        .fail(function() {
            $message.html('<span style="color: red;">✗ Error clearing cache. Please try again.</span>');
        })
        .always(function() {
            $button.prop('disabled', false).text(originalText);
            
            // Clear message after 3 seconds
            setTimeout(function() {
                $message.text('');
            }, 3000);
        });
    });
    
    // Toggle checkout methods section when checkout enabled checkbox changes
    // Handle both name attribute and ID selector for the checkbox
    $('input[name="authyo_otp_auth_checkout_enabled"], #authyo_checkout_enabled_toggle').on('change', function() {
        var isChecked = $(this).is(':checked');
        $('.authyo-checkout-methods-grid').toggle(isChecked);
    });
    
    // Trigger on page load to set initial state
    var checkoutEnabled = $('input[name="authyo_otp_auth_checkout_enabled"], #authyo_checkout_enabled_toggle').is(':checked');
    $('.authyo-checkout-methods-grid').toggle(checkoutEnabled);
});