<?php
/**
 * Aura Chat Button Uninstall
 *
 * Fired when the plugin is uninstalled.
 *
 * @package Aura_Chat_Button
 * @since 1.0.0
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('aura_chat_options');

// Delete statistics table
global $wpdb;
// Table name is constructed from trusted prefix, safe to use directly
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}aura_statistics");

// Clear any cached data
wp_cache_flush();
