<?php
/**
 * Plugin Name: Aura Chat
 * Plugin URI: https://wordpress.org/plugins/aura-chat-button
 * Description: High-conversion WhatsApp Support and WhatsApp Chat for WooCommerce. Add a professional floating button to improve customer service.
 * Version: 1.1.2
 * Author: Aura Team
 * Author URI: https://profiles.wordpress.org/auraplugin
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL-2.0+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Define Constants
define('AURA_CHAT_PATH', plugin_dir_path(__FILE__));
define('AURA_CHAT_URL', plugin_dir_url(__FILE__));

// Load Translations
function aura_chat_load_textdomain() {
    /**
     * To comply with WordPress.org policies while ensuring high-quality translations,
     * we first attempt to load the plugin's local translation files.
     * This ensures developer-verified translations take precedence.
     */
    $domain = 'aura-chat-button';
    $locale = apply_filters('plugin_locale', is_admin() && function_exists('get_user_locale') ? get_user_locale() : get_locale(), $domain);
    
    // Path to the local .mo file
    $mofile = $domain . '-' . $locale . '.mo';
    $path = dirname(plugin_basename(__FILE__)) . '/languages/';

    // Load local file from /languages/ folder first
    load_textdomain($domain, AURA_CHAT_PATH . 'languages/' . $mofile);
    
    // Then attempt standard loading (allows overrides if user placed files in global folder)
    load_plugin_textdomain($domain, false, $path);
}
add_action('init', 'aura_chat_load_textdomain');



// Include Files
require_once AURA_CHAT_PATH . 'includes/icons.php';
require_once AURA_CHAT_PATH . 'includes/settings-functions.php';
require_once AURA_CHAT_PATH . 'includes/admin-page.php';
require_once AURA_CHAT_PATH . 'includes/frontend-display.php';
require_once AURA_CHAT_PATH . 'includes/statistics-functions.php';

// Plugin Activation Hook - Create statistics table
register_activation_hook(__FILE__, 'aura_chat_create_statistics_table');

/**
 * Get plugin timezone
 * Returns DateTimeZone object for the configured timezone
 *
 * @return DateTimeZone
 */
function aura_chat_get_timezone() {
    $options = get_option('aura_chat_options', array());
    $timezone_string = isset($options['timezone']) && !empty($options['timezone']) ? $options['timezone'] : wp_timezone_string();
    
    try {
        return new DateTimeZone($timezone_string);
    } catch (Exception $e) {
        return wp_timezone();
    }
}

/**
 * Get current time in plugin timezone
 *
 * @param string $format Date format
 * @return string Formatted date/time
 */
function aura_chat_current_time($format = 'Y-m-d H:i:s') {
    $timezone = aura_chat_get_timezone();
    $datetime = new DateTime('now', $timezone);
    return $datetime->format($format);
}

/**
 * Add Settings link to plugin action links
 */
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'aura_chat_settings_link');
function aura_chat_settings_link($links) {
    $settings_link = '<a href="admin.php?page=aura_chat">' . __('Settings', 'aura-chat-button') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
