jQuery(document).ready(function ($) {
    const fab = $('#aura-fab');
    const chatBox = $('#aura-chat-box');
    const closeBtn = $('#aura-close-chat');
    const startChatBtn = $('#aura-start-chat');
    const widgetContainer = $('#aura-chat-widget');

    // Statistics tracking function
    function trackEvent(eventType) {
        if (typeof auraParams !== 'undefined' && auraParams.ajaxUrl) {
            $.ajax({
                url: auraParams.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'aura_track_event',
                    event_type: eventType,
                    nonce: auraParams.trackNonce || ''
                }
            });
        }
    }

    // Typewriter effect function
    function runTypewriter(element) {
        if (element.attr('data-typing') === 'true') return;

        if (!element.data('original-html')) {
            element.data('original-html', element.html());
        }

        const fullHtml = element.data('original-html');
        element.html('').css('opacity', '1');
        element.attr('data-typing', 'true');

        let i = 0;
        const speed = 40;

        function type() {
            // Stop typing if chat box is no longer active
            if (!chatBox.hasClass('active')) {
                element.attr('data-typing', 'false');
                return;
            }

            if (i < fullHtml.length) {
                if (fullHtml.substring(i, i + 1) === '<') {
                    const tagEnd = fullHtml.indexOf('>', i);
                    if (tagEnd !== -1) {
                        element.append(fullHtml.substring(i, tagEnd + 1));
                        i = tagEnd + 1;
                    } else {
                        element.append(fullHtml.substring(i, i + 1));
                        i++;
                    }
                } else {
                    element.append(fullHtml.substring(i, i + 1));
                    i++;
                }
                setTimeout(type, speed);
            } else {
                element.attr('data-typing', 'false');
            }
        }
        type();
    }

    const autoPopupDelay = Number(widgetContainer.data('auto-popup')) || 0;
    const mobileAutoPopupDelay = Number(widgetContainer.data('mobile-auto-popup')) || 0;
    const isMobileViewport = window.matchMedia('(max-width: 768px)').matches;
    // Use mobile delay if set and > 0, otherwise use desktop delay
    const effectiveDelay = (isMobileViewport && mobileAutoPopupDelay > 0) ? mobileAutoPopupDelay : autoPopupDelay;
    if (effectiveDelay > 0) {
        const now = Date.now();
        const lastPopup = localStorage.getItem('aura_last_auto_popup');
        const cooldown = 24 * 60 * 60 * 1000; // 24 hours in milliseconds

        if (!lastPopup || (now - lastPopup > cooldown)) {
            setTimeout(function () {
                if (!chatBox.hasClass('active') && !sessionStorage.getItem('aura_chat_closed')) {
                    chatBox.addClass('active');
                    fab.addClass('active');
                    localStorage.setItem('aura_last_auto_popup', now);

                    // Run typewriter on auto popup
                    const typingElement = chatBox.find('.aura-typing-text');
                    if (typingElement.length) {
                        runTypewriter(typingElement);
                    }
                }
            }, effectiveDelay * 1000);
        }
    }

    // Toggle Chat Box
    fab.on('click', function () {
        chatBox.toggleClass('active');
        fab.toggleClass('active');
        // Track click event
        trackEvent('click');
        // Track chat open if opening
        if (chatBox.hasClass('active')) {
            trackEvent('chat_open');

            // Run typewriter when opened
            const typingElement = chatBox.find('.aura-typing-text');
            if (typingElement.length) {
                runTypewriter(typingElement);
            }
        }
    });

    // Close Chat Box
    closeBtn.on('click', function () {
        chatBox.removeClass('active');
        fab.removeClass('active');
        sessionStorage.setItem('aura_chat_closed', 'true'); // Remember user closed it
    });

    // Help construct message with current page URL and title
    function buildMessage(baseMessage) {
        const message = (baseMessage || '').trim();
        // Get page title from H1 element (product/page name only)
        const h1Element = document.querySelector('h1');
        const pageTitle = h1Element ? h1Element.innerText.trim() : '';
        // Remove protocol (http:// or https://) so WhatsApp doesn't show link preview
        const pageUrl = window.location.href.replace(/^https?:\/\//, '');

        // Build page info line with title and URL
        const pageInfo = pageTitle ? pageTitle + '\n' + pageUrl : pageUrl;

        // Append page info to message
        if (message) {
            return message + '\n\n' + pageInfo;
        }
        return pageInfo;
    }

    // Helper to open chat
    function openChat(phone) {
        if (!phone) {
            alert('Phone number is not configured.');
            return;
        }

        const baseMessage = auraParams.prefilledMessage || '';
        const finalMessage = buildMessage(baseMessage);

        const url = `https://wa.me/${phone}?text=${encodeURIComponent(finalMessage)}`;
        window.open(url, '_blank');
    }

    // Start Chat
    startChatBtn.on('click', function () {
        const phone = auraParams.phoneNumber;
        trackEvent('conversion');
        openChat(phone);
    });

    // Close on click outside
    $(document).on('click', function (e) {
        if (!$(e.target).closest('#aura-chat-widget').length) {
            chatBox.removeClass('active');
            fab.removeClass('active');
        }
    });

    // Offline Chat Button
    $('#aura-offline-chat').on('click', function () {
        const phone = auraParams.phoneNumber;
        if (!phone) {
            alert('Phone number is not configured.');
            return;
        }

        const baseMessage = $(this).data('offline-message') || '';
        const finalMessage = buildMessage(baseMessage);

        const url = `https://wa.me/${phone}?text=${encodeURIComponent(finalMessage)}`;
        window.open(url, '_blank');
        trackEvent('conversion');
    });

    // Positioning is now handled by CSS via variables for better performance and boundary safety (clamping)

});
