<?php
/**
 * Plugin Name: Aura Chat Button
 * Plugin URI: https://wordpress.org/plugins/aura-chat-button
 * Description: WhatsApp chat button plugin for WordPress. Add a floating WhatsApp button with business hours scheduling, click statistics, conversion tracking, customizable button styles, live preview, and mobile-optimized responsive design.
 * Version: 1.0.2
 * Author: Aura Team
 * Author URI: https://profiles.wordpress.org/auraplugin
 * Text Domain: aura-chat-button
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL-2.0+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Define Constants
define('AURA_CHAT_PATH', plugin_dir_path(__FILE__));
define('AURA_CHAT_URL', plugin_dir_url(__FILE__));

// Include Files
require_once AURA_CHAT_PATH . 'includes/icons.php';
require_once AURA_CHAT_PATH . 'includes/settings-functions.php';
require_once AURA_CHAT_PATH . 'includes/admin-page.php';
require_once AURA_CHAT_PATH . 'includes/frontend-display.php';
require_once AURA_CHAT_PATH . 'includes/statistics-functions.php';

// Plugin Activation Hook - Create statistics table
register_activation_hook(__FILE__, 'aura_chat_create_statistics_table');

/**
 * Get plugin timezone
 * Returns DateTimeZone object for the configured timezone
 *
 * @return DateTimeZone
 */
function aura_chat_get_timezone() {
    $options = get_option('aura_chat_options', array());
    $timezone_string = isset($options['timezone']) && !empty($options['timezone']) ? $options['timezone'] : wp_timezone_string();
    
    try {
        return new DateTimeZone($timezone_string);
    } catch (Exception $e) {
        return wp_timezone();
    }
}

/**
 * Get current time in plugin timezone
 *
 * @param string $format Date format
 * @return string Formatted date/time
 */
function aura_chat_current_time($format = 'Y-m-d H:i:s') {
    $timezone = aura_chat_get_timezone();
    $datetime = new DateTime('now', $timezone);
    return $datetime->format($format);
}
