<?php
/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/includes
 */

/**
 * Fired during plugin deactivation.
 */
class Audit_Export_Deactivator {

	/**
	 * Plugin deactivation routine.
	 *
	 * Remove scheduled events but keep data.
	 */
	public static function deactivate() {
		// Clear scheduled cron events
		wp_clear_scheduled_hook( 'audit_export_cron_hook' );
		wp_clear_scheduled_hook( 'audit_export_process_queue' );
		
		// Clear any transients
		self::clear_transients();
		
		// Flush rewrite rules
		flush_rewrite_rules();
	}

	/**
	 * Clear plugin transients.
	 */
	private static function clear_transients() {
		global $wpdb;
		
		// Delete transients with our prefix
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery -- Direct query necessary for transient cleanup on deactivation.
		$wpdb->query( 
			"DELETE FROM {$wpdb->options} 
			WHERE option_name LIKE '_transient_audit_export_%' 
			OR option_name LIKE '_transient_timeout_audit_export_%'"
		);
	}
}