<?php
/**
 * Themes audit implementation.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/includes/audits
 */

/**
 * Themes audit class.
 */
class Audit_Export_Themes extends Audit_Export_Audit {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->label = __( 'Themes', 'audit-export' );
		$this->description = __( 'Audit information about installed themes.', 'audit-export' );
		$this->group = 'system';
		$this->data_type = 'flat';
		$this->identifier = 'stylesheet';
		$this->headers = array(
			__( 'Theme Name', 'audit-export' ),
			__( 'Version', 'audit-export' ),
			__( 'Author', 'audit-export' ),
			__( 'Status', 'audit-export' ),
			__( 'Parent Theme', 'audit-export' ),
			__( 'Update Available', 'audit-export' ),
		);
	}

	/**
	 * Prepare data for the audit.
	 *
	 * @return array
	 */
	public function prepare_data() {
		$themes = wp_get_themes();
		return $themes;
	}

	/**
	 * Process a single data item.
	 *
	 * @param WP_Theme $theme The theme object.
	 * @return array
	 */
	public function process_data( $theme ) {
		$stylesheet = $theme->get_stylesheet();
		$current_theme = get_stylesheet();
		
		// Determine status
		if ( $stylesheet === $current_theme ) {
			$status = __( 'Active', 'audit-export' );
		} else {
			$status = __( 'Inactive', 'audit-export' );
		}
		
		// Get parent theme
		$parent_theme = $theme->parent() ? $theme->parent()->get( 'Name' ) : __( 'None', 'audit-export' );
		
		// Check for updates
		$update_available = __( 'No', 'audit-export' );
		$update_themes = get_site_transient( 'update_themes' );
		
		if ( isset( $update_themes->response[ $stylesheet ] ) ) {
			$update_available = __( 'Yes', 'audit-export' );
		}

		return array(
			$theme->get( 'Name' ),
			$theme->get( 'Version' ),
			$theme->get( 'Author' ),
			$status,
			$parent_theme,
			$update_available,
		);
	}
}