<?php
/**
 * Provide an admin area view for the tools page.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<div class="wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
	
	<p class="description">
		<?php esc_html_e( 'Tools for managing and debugging Audit Export functionality.', 'audit-export' ); ?>
	</p>

	<?php settings_errors( 'audit_export_tools' ); ?>

	<div class="audit-export-tools">
		
		<!-- Cron Tools -->
		<div class="tool-section">
			<h2><?php esc_html_e( 'Cron Management', 'audit-export' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Cron Status', 'audit-export' ); ?></th>
					<td>
						<?php
						$audit_export_settings = get_option( 'audit_export_settings', array() );
						$audit_export_cron_enabled = ! empty( $audit_export_settings['enable_cron'] );
						$audit_export_next_run = $cron_service->get_next_scheduled_run();
						?>
						
						<?php if ( $audit_export_cron_enabled ) : ?>
							<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
							<?php esc_html_e( 'Enabled', 'audit-export' ); ?>

							<?php if ( $audit_export_next_run ) : ?>
							<br><small>
							<?php
							echo esc_html( sprintf(
							/* translators: %s: date and time of next scheduled run */
							__( 'Next run: %s', 'audit-export' ),
							wp_date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $audit_export_next_run )
							) );
							?>
							</small>
							<?php endif; ?>
						<?php else : ?>
							<span class="dashicons dashicons-dismiss" style="color: #dc3232;"></span>
							<?php esc_html_e( 'Disabled', 'audit-export' ); ?>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Force Cron Run', 'audit-export' ); ?></th>
					<td>
						<form method="post" style="display: inline;">
							<?php wp_nonce_field( 'audit_export_tools' ); ?>
							<input type="hidden" name="action" value="force_cron">
							<input type="submit" class="button" value="<?php esc_attr_e( 'Force Run Now', 'audit-export' ); ?>">
						</form>
						<p class="description"><?php esc_html_e( 'Manually trigger cron processing regardless of schedule.', 'audit-export' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<!-- Queue Tools -->
		<div class="tool-section">
			<h2><?php esc_html_e( 'Queue Management', 'audit-export' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Queue Status', 'audit-export' ); ?></th>
					<td>
						<?php
						$audit_export_queue_count = $queue_service->get_queue_count();
						$audit_export_next_item = $queue_service->get_next_queue_item();
						?>
						
						<?php
						echo esc_html( sprintf(
							/* translators: %d: number of items in the queue */
							__( '%d items in queue', 'audit-export' ),
							$audit_export_queue_count
						) );
						?>

						<?php if ( $audit_export_next_item ) : ?>
							<br><small>
								<?php
								echo esc_html( sprintf(
									/* translators: 1: item name, 2: time */
									__( 'Next item: %1$s at %2$s', 'audit-export' ),
									esc_html( $audit_export_next_item['args'][0] ),
									wp_date( get_option( 'time_format' ), $audit_export_next_item['timestamp'] )
								) );
								?>
							</small>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Process Queue', 'audit-export' ); ?></th>
					<td>
						<form method="post" style="display: inline; margin-right: 10px;">
							<?php wp_nonce_field( 'audit_export_tools' ); ?>
							<input type="hidden" name="action" value="process_queue">
							<input type="submit" class="button" value="<?php esc_attr_e( 'Process 5 Items', 'audit-export' ); ?>" <?php disabled( $audit_export_queue_count, 0 ); ?>>
						</form>
						<form method="post" style="display: inline;">
							<?php wp_nonce_field( 'audit_export_tools' ); ?>
							<input type="hidden" name="action" value="clear_queue">
							<input type="submit" class="button" value="<?php esc_attr_e( 'Clear Queue', 'audit-export' ); ?>" <?php disabled( $audit_export_queue_count, 0 ); ?>>
						</form>
						<p class="description"><?php esc_html_e( 'Manually process queued items or clear the entire queue.', 'audit-export' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<!-- Remote Post Tools -->
		<div class="tool-section">
			<h2><?php esc_html_e( 'Remote Post Tools', 'audit-export' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Remote Post Status', 'audit-export' ); ?></th>
					<td>
						<?php if ( $remote_post_service->is_enabled() ) : ?>
							<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
							<?php esc_html_e( 'Enabled', 'audit-export' ); ?>
						<?php else : ?>
							<span class="dashicons dashicons-dismiss" style="color: #dc3232;"></span>
							<?php esc_html_e( 'Disabled', 'audit-export' ); ?>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Test Connection', 'audit-export' ); ?></th>
					<td>
						<form method="post" style="display: inline;">
							<?php wp_nonce_field( 'audit_export_tools' ); ?>
							<input type="hidden" name="action" value="test_connection">
							<input type="submit" class="button" value="<?php esc_attr_e( 'Test Connection', 'audit-export' ); ?>" <?php disabled( ! $remote_post_service->is_enabled() ); ?>>
						</form>
						<p class="description"><?php esc_html_e( 'Test the connection to the remote endpoint.', 'audit-export' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<!-- System Information -->
		<div class="tool-section">
			<h2><?php esc_html_e( 'System Information', 'audit-export' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Plugin Version', 'audit-export' ); ?></th>
					<td><?php echo esc_html( AUDIT_EXPORT_VERSION ); ?></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'WordPress Version', 'audit-export' ); ?></th>
					<td><?php echo esc_html( get_bloginfo( 'version' ) ); ?></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'PHP Version', 'audit-export' ); ?></th>
					<td><?php echo esc_html( PHP_VERSION ); ?></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Available Audits', 'audit-export' ); ?></th>
					<td>
						<?php
						$audit_export_audit_manager = new Audit_Export_Audit_Manager();
						$audit_export_audits = $audit_export_audit_manager->get_audits();
						echo count( $audit_export_audits );
						?>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Database Table', 'audit-export' ); ?></th>
					<td>
						<?php
						global $wpdb;
						$audit_export_table_name = $wpdb->prefix . 'audit_export_reports';
						// phpcs:ignore WordPress.DB.DirectDatabaseQuery -- Direct query necessary for admin display.
						$audit_export_table_exists = $wpdb->get_var( $wpdb->prepare( 'SHOW TABLES LIKE %s', $audit_export_table_name ) ) === $audit_export_table_name;

						if ( $audit_export_table_exists ) {
							// phpcs:ignore WordPress.DB.DirectDatabaseQuery -- Direct query necessary for admin display.
							$audit_export_row_count = $wpdb->get_var( $wpdb->prepare( 'SELECT COUNT(*) FROM %i', $audit_export_table_name ) );
							echo '<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span> ';
							echo esc_html( sprintf(
								/* translators: %d: number of database records */
								__( 'Exists (%d records)', 'audit-export' ),
								$audit_export_row_count
							) );
						} else {
							echo '<span class="dashicons dashicons-dismiss" style="color: #dc3232;"></span> ';
							esc_html_e( 'Missing', 'audit-export' );
						}
						?>
					</td>
				</tr>
			</table>
		</div>
		
	</div>
</div>