<?php
/**
 * Provide an admin area view for the settings page.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}

// phpcs:disable WordPress.Security.NonceVerification.Recommended -- Read-only tab switching for settings display.
$audit_export_active_tab = isset( $_GET['tab'] ) ? sanitize_key( wp_unslash( $_GET['tab'] ) ) : 'core';
// phpcs:enable WordPress.Security.NonceVerification.Recommended
?>

<div class="wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
	
	<nav class="nav-tab-wrapper">
		<a href="?page=audit-export-settings&tab=core" class="nav-tab <?php echo 'core' === $audit_export_active_tab ? 'nav-tab-active' : ''; ?>">
			<?php esc_html_e( 'Core Settings', 'audit-export' ); ?>
		</a>
		<a href="?page=audit-export-settings&tab=remote-post" class="nav-tab <?php echo 'remote-post' === $audit_export_active_tab ? 'nav-tab-active' : ''; ?>">
			<?php esc_html_e( 'Remote Post', 'audit-export' ); ?>
		</a>
	</nav>

	<div class="tab-content">
		<?php if ( 'core' === $audit_export_active_tab ) : ?>
			<form method="post" action="options.php">
				<?php
				settings_fields( 'audit_export_settings_group' );
				do_settings_sections( 'audit-export-settings' );
				submit_button();
				?>
			</form>
			
			<div class="audit-export-info">
				<h3><?php esc_html_e( 'File Export Information', 'audit-export' ); ?></h3>
				<table class="form-table">
					<tr>
						<th scope="row"><?php esc_html_e( 'Uploads Directory', 'audit-export' ); ?></th>
						<td>
							<?php
							$audit_export_upload_dir = wp_upload_dir();
							echo '<code>' . esc_html( $audit_export_upload_dir['basedir'] ) . '</code>';
							?>
							<p class="description"><?php esc_html_e( 'WordPress uploads directory path.', 'audit-export' ); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php esc_html_e( 'Content Directory', 'audit-export' ); ?></th>
						<td>
							<code><?php echo esc_html( WP_CONTENT_DIR ); ?></code>
							<p class="description"><?php esc_html_e( 'WordPress content directory path.', 'audit-export' ); ?></p>
						</td>
					</tr>
				</table>
			</div>
			
			<div class="audit-export-info">
				<h3><?php esc_html_e( 'Cron Information', 'audit-export' ); ?></h3>
				<table class="form-table">
					<tr>
						<th scope="row"><?php esc_html_e( 'WordPress Cron Status', 'audit-export' ); ?></th>
						<td>
							<?php if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) : ?>
								<span class="dashicons dashicons-warning" style="color: #f56e28;"></span>
								<?php esc_html_e( 'WordPress cron is disabled', 'audit-export' ); ?>
								<p class="description"><?php esc_html_e( 'WP_CRON is disabled. You will need to set up system cron to trigger WordPress cron.', 'audit-export' ); ?></p>
							<?php else : ?>
								<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
								<?php esc_html_e( 'WordPress cron is enabled', 'audit-export' ); ?>
							<?php endif; ?>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php esc_html_e( 'Next Scheduled Run', 'audit-export' ); ?></th>
						<td>
							<?php
							$audit_export_cron_service = new Audit_Export_Cron( new Audit_Export_Audit_Manager() );
							$audit_export_next_run = $audit_export_cron_service->get_next_scheduled_run();

							if ( $audit_export_next_run ) {
								echo esc_html( wp_date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $audit_export_next_run ) );
							} else {
								esc_html_e( 'Not scheduled', 'audit-export' );
							}
							?>
						</td>
					</tr>
				</table>
			</div>
			
		<?php elseif ( 'remote-post' === $audit_export_active_tab ) : ?>
			<form method="post" action="options.php">
				<?php
				settings_fields( 'audit_export_remote_post_settings_group' );
				do_settings_sections( 'audit-export-remote-post-settings' );
				submit_button();
				?>
			</form>
			
			<div class="audit-export-info">
				<h3><?php esc_html_e( 'Test Connection', 'audit-export' ); ?></h3>
				<p><?php esc_html_e( 'Test the connection to your remote endpoint to ensure it\'s configured correctly.', 'audit-export' ); ?></p>
				<button type="button" id="test-connection" class="button">
					<?php esc_html_e( 'Test Connection', 'audit-export' ); ?>
				</button>
				<div id="test-result" style="margin-top: 10px;"></div>
			</div>
			
			<div class="audit-export-info">
				<h3><?php esc_html_e( 'Available Hooks', 'audit-export' ); ?></h3>
				<p><?php esc_html_e( 'The following hooks are available for customizing remote post functionality:', 'audit-export' ); ?></p>
				<ul>
					<li><code>audit_export_post_url</code> - <?php esc_html_e( 'Modify the remote URL', 'audit-export' ); ?></li>
					<li><code>audit_export_post_site_info</code> - <?php esc_html_e( 'Modify site information sent with data', 'audit-export' ); ?></li>
					<li><code>audit_export_post_data</code> - <?php esc_html_e( 'Modify the post data before sending', 'audit-export' ); ?></li>
					<li><code>audit_export_post_request_args</code> - <?php esc_html_e( 'Modify request arguments', 'audit-export' ); ?></li>
				</ul>
			</div>
		<?php endif; ?>
	</div>
</div>

