<?php
/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Since WordPress 4.6, when a plugin is hosted on WordPress.org,
 * translations are automatically loaded by WordPress core.
 * This class is kept for structural consistency but no longer
 * needs to call load_plugin_textdomain().
 *
 * @see https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/
 */
class Audit_Export_i18n {

	/**
	 * Initialize internationalization.
	 *
	 * Since WordPress 4.6, translations for plugins hosted on WordPress.org
	 * are automatically loaded by WordPress core. No manual loading is required.
	 *
	 * This method is kept for backwards compatibility with the plugin's
	 * hook registration system but performs no action.
	 *
	 * @since 1.0.0
	 */
	public function load_plugin_textdomain() {
		// Translations are automatically loaded by WordPress for plugins
		// hosted on WordPress.org since WordPress 4.6.
		// No action needed here.
	}
}
