<?php
/**
 * Menus audit implementation.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/includes/audits
 */

/**
 * Menus audit class.
 */
class Audit_Export_Menus extends Audit_Export_Audit {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->label = __( 'Menus', 'audit-export' );
		$this->description = __( 'Audit information about navigation menus.', 'audit-export' );
		$this->group = 'content';
		$this->data_type = 'flat';
		$this->identifier = 'term_id';
		$this->headers = array(
			__( 'Menu Name', 'audit-export' ),
			__( 'Menu ID', 'audit-export' ),
			__( 'Item Count', 'audit-export' ),
			__( 'Locations', 'audit-export' ),
			__( 'Last Modified', 'audit-export' ),
		);
	}

	/**
	 * Prepare data for the audit.
	 *
	 * @return array
	 */
	public function prepare_data() {
		$menus = wp_get_nav_menus();
		return $menus;
	}

	/**
	 * Process a single data item.
	 *
	 * @param WP_Term $menu The menu term object.
	 * @return array
	 */
	public function process_data( $menu ) {
		// Get menu items count
		$menu_items = wp_get_nav_menu_items( $menu->term_id );
		$item_count = is_array( $menu_items ) ? count( $menu_items ) : 0;
		
		// Get assigned locations
		$locations = get_nav_menu_locations();
		$assigned_locations = array();
		
		foreach ( $locations as $location => $menu_id ) {
			if ( $menu_id == $menu->term_id ) {
				$assigned_locations[] = $location;
			}
		}
		
		$location_text = ! empty( $assigned_locations ) ? implode( ', ', $assigned_locations ) : __( 'None', 'audit-export' );
		
		// Get last modified date
		$last_modified = __( 'Unknown', 'audit-export' );
		if ( ! empty( $menu_items ) ) {
			$latest_date = 0;
			foreach ( $menu_items as $item ) {
				$post_date = strtotime( $item->post_modified );
				if ( $post_date > $latest_date ) {
					$latest_date = $post_date;
				}
			}
			if ( $latest_date > 0 ) {
				$last_modified = gmdate( 'Y-m-d H:i:s', $latest_date );
			}
		}

		return array(
			$menu->name,
			$menu->term_id,
			$item_count,
			$location_text,
			$last_modified,
		);
	}
}