<?php
/**
 * Plugin Name: Audit Export
 * Plugin URI: https://blog.will.gg/projects/audit-export-plugin
 * Description: A powerful auditing plugin for WordPress, designed to help site administrators and developers analyze and report on the entity structure and overall usage of their WordPress site.
 * Version: 1.0.1
 * Requires at least: 6.2
 * Requires PHP: 7.2
 * Author: Will Jackson
 * Author URI: https://blog.will.gg
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: audit-export
 * Domain Path: /languages
 *
 * @package Audit_Export
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Plugin version.
define( 'AUDIT_EXPORT_VERSION', '1.0.1' );

// Plugin name.
define( 'AUDIT_EXPORT_NAME', 'audit-export' );

// Plugin directory path.
define( 'AUDIT_EXPORT_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

// Plugin directory URL.
define( 'AUDIT_EXPORT_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Plugin basename.
define( 'AUDIT_EXPORT_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-audit-export-activator.php
 */
function audit_export_activate() {
	require_once AUDIT_EXPORT_PLUGIN_DIR . 'includes/class-audit-export-activator.php';
	Audit_Export_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-audit-export-deactivator.php
 */
function audit_export_deactivate() {
	require_once AUDIT_EXPORT_PLUGIN_DIR . 'includes/class-audit-export-deactivator.php';
	Audit_Export_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'audit_export_activate' );
register_deactivation_hook( __FILE__, 'audit_export_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require AUDIT_EXPORT_PLUGIN_DIR . 'includes/class-audit-export.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function audit_export_run() {
	$plugin = new Audit_Export();
	$plugin->run();
}
audit_export_run();