<?php
/**
 * Provide an admin area view for a single report.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<div class="wrap">
	<h1>
		<?php echo esc_html( $audit->get_label() ); ?>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export' ) ); ?>" class="page-title-action">
			<?php esc_html_e( 'Back to Overview', 'audit-export' ); ?>
		</a>
	</h1>
	
	<div class="audit-report-header">
		<div class="audit-report-meta">
			<p class="description"><?php echo esc_html( $audit->get_description() ); ?></p>
			<div class="audit-meta-info">
				<span class="audit-group">
					<?php
					echo esc_html( sprintf(
						/* translators: %s: group name */
						__( 'Group: %s', 'audit-export' ),
						ucfirst( $audit->get_group() )
					) );
					?>
				</span>
				<span class="audit-data-type">
					<?php
					echo esc_html( sprintf(
						/* translators: %s: data type */
						__( 'Type: %s', 'audit-export' ),
						ucfirst( $audit->get_data_type() )
					) );
					?>
				</span>
				<?php if ( $last_processed ) : ?>
					<span class="audit-last-processed">
						<?php
						echo esc_html( sprintf(
							/* translators: %s: date and time */
							__( 'Last processed: %s', 'audit-export' ),
							wp_date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $last_processed ) )
						) );
						?>
					</span>
				<?php endif; ?>
			</div>
		</div>
		
		<div class="audit-report-actions">
			<button type="button" class="button button-primary process-audit" data-audit-id="<?php echo esc_attr( $audit_id ); ?>">
				<?php esc_html_e( 'Run Audit', 'audit-export' ); ?>
			</button>
			<?php if ( $report_data ) : ?>
				<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin-ajax.php?action=audit_export_download&audit_id=' . urlencode( $audit_id ) ), 'audit_export_nonce', 'nonce' ) ); ?>" class="button">
					<?php esc_html_e( 'Download CSV', 'audit-export' ); ?>
				</a>
			<?php endif; ?>
		</div>
	</div>

	<?php if ( empty( $report_data ) ) : ?>
		<div class="notice notice-info">
			<p><?php esc_html_e( 'No report data available. Click "Run Audit" to generate a report.', 'audit-export' ); ?></p>
		</div>
	<?php else : ?>
		<?php
		$audit_export_headers = isset( $report_data['headers'] ) ? $report_data['headers'] : $audit->get_headers();
		$audit_export_data = isset( $report_data['data'] ) ? $report_data['data'] : array();
		?>
		
		<div class="audit-report-summary">
			<h3><?php esc_html_e( 'Report Summary', 'audit-export' ); ?></h3>
			<p>
				<?php
				echo esc_html( sprintf(
					/* translators: %d: number of records */
					__( 'Total records: %d', 'audit-export' ),
					count( $audit_export_data )
				) );
				?>
			</p>
		</div>

		<div class="audit-report-data">
			<table class="wp-list-table widefat fixed striped">
				<thead>
					<tr>
						<?php foreach ( $audit_export_headers as $audit_export_header ) : ?>
							<th scope="col"><?php echo esc_html( $audit_export_header ); ?></th>
						<?php endforeach; ?>
					</tr>
				</thead>
				<tbody>
					<?php if ( empty( $audit_export_data ) ) : ?>
						<tr>
							<td colspan="<?php echo count( $audit_export_headers ); ?>" class="no-items">
								<?php esc_html_e( 'No data found.', 'audit-export' ); ?>
							</td>
						</tr>
					<?php else : ?>
						<?php foreach ( $audit_export_data as $audit_export_row ) : ?>
							<tr>
								<?php foreach ( $audit_export_row as $audit_export_cell ) : ?>
									<td><?php echo esc_html( $audit_export_cell ); ?></td>
								<?php endforeach; ?>
							</tr>
						<?php endforeach; ?>
					<?php endif; ?>
				</tbody>
			</table>
		</div>
	<?php endif; ?>
</div>
