<?php
/**
 * Provide an admin area view for the reports overview.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<div class="wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
	
	<div class="audit-export-header">
		<p class="description">
		<?php esc_html_e( 'Audit Export provides comprehensive auditing and reporting for your WordPress site. Run audits to analyze entity structure, content usage, and system configuration.', 'audit-export' ); ?>
		</p>
		
		<div class="audit-export-actions">
			<button type="button" id="process-all-audits" class="button button-primary">
				<?php esc_html_e( 'Process All Audits', 'audit-export' ); ?>
			</button>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export-tools' ) ); ?>" class="button">
				<?php esc_html_e( 'Tools', 'audit-export' ); ?>
			</a>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export-settings' ) ); ?>" class="button">
				<?php esc_html_e( 'Settings', 'audit-export' ); ?>
			</a>
		</div>
	</div>

	<?php settings_errors( 'audit_export_messages' ); ?>

	<?php if ( empty( $grouped_audits ) ) : ?>
		<div class="notice notice-warning">
			<p><?php esc_html_e( 'No audit types are currently registered.', 'audit-export' ); ?></p>
		</div>
	<?php else : ?>
		<div class="audit-export-overview">
			<?php foreach ( $grouped_audits as $audit_export_group => $audit_export_audits ) : ?>
				<div class="audit-group">
					<h2 class="audit-group-title">
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export&group=' . urlencode( $audit_export_group ) ) ); ?>">
							<?php echo esc_html( ucfirst( $audit_export_group ) ); ?>
						</a>
						<span class="audit-count">(<?php echo count( $audit_export_audits ); ?>)</span>
					</h2>

					<div class="audit-list">
						<?php foreach ( $audit_export_audits as $audit_export_audit_id => $audit_export_definition ) : ?>
							<?php
								$audit_export_last_run = null;
								foreach ( $available_reports as $audit_export_report ) {
									if ( $audit_export_report['audit_name'] === $audit_export_audit_id ) {
										$audit_export_last_run = $audit_export_report['last_run'];
										break;
									}
								}
							?>
							<div class="audit-item" data-audit-id="<?php echo esc_attr( $audit_export_audit_id ); ?>">
								<div class="audit-info">
									<h3 class="audit-title">
										<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export&audit=' . urlencode( $audit_export_audit_id ) ) ); ?>">
											<?php echo esc_html( $audit_export_definition['label'] ); ?>
										</a>
									</h3>
									<p class="audit-description"><?php echo esc_html( $audit_export_definition['description'] ); ?></p>
									<div class="audit-meta">
										<span class="audit-data-type"><?php echo esc_html( ucfirst( $audit_export_definition['data_type'] ) ); ?></span>
										<?php if ( $audit_export_last_run ) : ?>
										<span class="audit-last-run">
										<?php
										echo esc_html( sprintf(
											/* translators: %s: date and time of last run */
											__( 'Last run: %s', 'audit-export' ),
											esc_html( wp_date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $audit_export_last_run ) ) )
										) );
										?>
										</span>
										<?php else : ?>
										<span class="audit-last-run audit-never-run"><?php esc_html_e( 'Never run', 'audit-export' ); ?></span>
										<?php endif; ?>
									</div>
								</div>

								<div class="audit-actions">
									<button type="button" class="button process-audit" data-audit-id="<?php echo esc_attr( $audit_export_audit_id ); ?>">
										<?php esc_html_e( 'Run Audit', 'audit-export' ); ?>
									</button>
									<?php if ( $audit_export_last_run ) : ?>
									<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export&audit=' . urlencode( $audit_export_audit_id ) ) ); ?>" class="button">
										<?php esc_html_e( 'View Report', 'audit-export' ); ?>
									</a>
									<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin-ajax.php?action=audit_export_download&audit_id=' . urlencode( $audit_export_audit_id ) ), 'audit_export_nonce', 'nonce' ) ); ?>" class="button">
										<?php esc_html_e( 'Download CSV', 'audit-export' ); ?>
									</a>
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>
