<?php
/**
 * Provide an admin area view for group reports.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<div class="wrap">
	<h1>
		<?php echo esc_html( ucfirst( $group ) . ' ' . __( 'Audits', 'audit-export' ) ); ?>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export' ) ); ?>" class="page-title-action">
			<?php esc_html_e( 'Back to Overview', 'audit-export' ); ?>
		</a>
	</h1>
	
	<p class="description">
		<?php 
		echo esc_html( sprintf(
			/* translators: %s: group name */
			__( 'All audits in the %s group.', 'audit-export' ),
			esc_html( $group )
		) );
		?>
	</p>

	<?php if ( empty( $audits ) ) : ?>
		<div class="notice notice-warning">
			<p>
				<?php 
				echo esc_html( sprintf(
					/* translators: %s: group name */
					__( 'No audits found in the %s group.', 'audit-export' ),
					esc_html( $group )
				) );
				?>
			</p>
		</div>
	<?php else : ?>
		<div class="audit-group-list">
			<?php foreach ( $audits as $audit_export_audit_id => $audit_export_audit_class ) : ?>
				<?php
					$audit_export_definition = isset( $audit_definitions[ $audit_export_audit_id ] ) ? $audit_definitions[ $audit_export_audit_id ] : null;
					if ( ! $audit_export_definition ) {
						continue;
					}

					$audit_export_last_run = null;
					$audit_export_available_reports = $report_service->get_available_reports();
					foreach ( $audit_export_available_reports as $audit_export_report ) {
						if ( $audit_export_report['audit_name'] === $audit_export_audit_id ) {
							$audit_export_last_run = $audit_export_report['last_run'];
							break;
						}
					}
				?>
				<div class="audit-item" data-audit-id="<?php echo esc_attr( $audit_export_audit_id ); ?>">
					<div class="audit-info">
						<h3 class="audit-title">
							<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export&audit=' . urlencode( $audit_export_audit_id ) ) ); ?>">
								<?php echo esc_html( $audit_export_definition['label'] ); ?>
							</a>
						</h3>
						<p class="audit-description"><?php echo esc_html( $audit_export_definition['description'] ); ?></p>
						<div class="audit-meta">
							<span class="audit-data-type"><?php echo esc_html( ucfirst( $audit_export_definition['data_type'] ) ); ?></span>
							<?php if ( $audit_export_last_run ) : ?>
							<span class="audit-last-run">
							<?php
							echo esc_html( sprintf(
								/* translators: %s: date and time of last run */
								__( 'Last run: %s', 'audit-export' ),
								esc_html( wp_date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $audit_export_last_run ) ) )
							) );
							?>
							</span>
							<?php else : ?>
							<span class="audit-last-run audit-never-run"><?php esc_html_e( 'Never run', 'audit-export' ); ?></span>
							<?php endif; ?>
						</div>
					</div>

					<div class="audit-actions">
						<button type="button" class="button process-audit" data-audit-id="<?php echo esc_attr( $audit_export_audit_id ); ?>">
							<?php esc_html_e( 'Run Audit', 'audit-export' ); ?>
						</button>
						<?php if ( $audit_export_last_run ) : ?>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=audit-export&audit=' . urlencode( $audit_export_audit_id ) ) ); ?>" class="button">
							<?php esc_html_e( 'View Report', 'audit-export' ); ?>
						</a>
						<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin-ajax.php?action=audit_export_download&audit_id=' . urlencode( $audit_export_audit_id ) ), 'audit_export_nonce', 'nonce' ) ); ?>" class="button">
							<?php esc_html_e( 'Download CSV', 'audit-export' ); ?>
						</a>
						<?php endif; ?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>
