/**
 * Audit Export Admin Inline Scripts
 *
 * Handles AJAX functionality for the admin pages.
 *
 * @package    Audit_Export
 * @subpackage Audit_Export/admin/js
 */

(function($) {
	'use strict';

	/**
	 * Main AuditExportAdmin object.
	 */
	var AuditExportAdmin = {

		/**
		 * Initialize the admin scripts.
		 */
		init: function() {
			this.bindProcessAudit();
			this.bindProcessAllAudits();
			this.bindTestConnection();
		},

		/**
		 * Bind process audit button click handlers.
		 */
		bindProcessAudit: function() {
			$(document).on('click', '.process-audit', function(e) {
				e.preventDefault();
				
				var $button = $(this);
				var auditId = $button.data('audit-id');
				var originalText = $button.text();
				
				$button.prop('disabled', true).text(audit_export_ajax.strings.processing);
				
				$.post(audit_export_ajax.ajax_url, {
					action: 'audit_export_process',
					audit_id: auditId,
					nonce: audit_export_ajax.nonce
				})
				.done(function(response) {
					if (response.success) {
						$button.text(audit_export_ajax.strings.completed);
						// Reload page after a short delay to show updated data
						setTimeout(function() {
							location.reload();
						}, 1500);
					} else {
						alert('Error: ' + response.data.message);
						$button.prop('disabled', false).text(originalText);
					}
				})
				.fail(function() {
					alert(audit_export_ajax.strings.error);
					$button.prop('disabled', false).text(originalText);
				});
			});
		},

		/**
		 * Bind process all audits button click handler.
		 */
		bindProcessAllAudits: function() {
			$('#process-all-audits').on('click', function(e) {
				e.preventDefault();
				
				if (!confirm(audit_export_ajax.strings.confirm_process_all)) {
					return;
				}
				
				var $button = $(this);
				var originalText = $button.text();
				
				$button.prop('disabled', true).text(audit_export_ajax.strings.processing);
				
				$.post(audit_export_ajax.ajax_url, {
					action: 'audit_export_process',
					process_all: 'true',
					nonce: audit_export_ajax.nonce
				})
				.done(function(response) {
					if (response.success) {
						$button.text(audit_export_ajax.strings.completed);
						alert(response.data.message);
						// Reload page after a short delay
						setTimeout(function() {
							location.reload();
						}, 1500);
					} else {
						alert('Error: ' + response.data.message);
						$button.prop('disabled', false).text(originalText);
					}
				})
				.fail(function() {
					alert(audit_export_ajax.strings.error);
					$button.prop('disabled', false).text(originalText);
				});
			});
		},

		/**
		 * Bind test connection button click handler.
		 */
		bindTestConnection: function() {
			$('#test-connection').on('click', function(e) {
				e.preventDefault();
				
				var $button = $(this);
				var $result = $('#test-result');
				var originalText = $button.text();
				
				$button.prop('disabled', true).text(audit_export_ajax.strings.testing);
				$result.html('');
				
				$.post(audit_export_ajax.ajax_url, {
					action: 'audit_export_test_connection',
					nonce: audit_export_ajax.test_connection_nonce
				})
				.done(function(response) {
					if (response.success) {
						$result.html('<div class="notice notice-success inline"><p>' + response.data.message + '</p></div>');
					} else {
						$result.html('<div class="notice notice-error inline"><p>' + response.data.message + '</p></div>');
					}
				})
				.fail(function() {
					$result.html('<div class="notice notice-error inline"><p>' + audit_export_ajax.strings.connection_failed + '</p></div>');
				})
				.always(function() {
					$button.prop('disabled', false).text(originalText);
				});
			});
		}
	};

	// Initialize when document is ready
	$(document).ready(function() {
		AuditExportAdmin.init();
	});

})(jQuery);
