<?php

defined('WPINC') or die;

class ATMCEVNTS_Template_Utils {
    public function __construct() {
    }

    function get_template_path($relative_file_path) {
        // Get the selected theme
        $selected_theme = ATMCEVNTS_Theme_Manager::get_selected_theme();
        
        // 1. Load from child theme override (highest priority)
        $child_theme_directory = get_stylesheet_directory();
        $absolute_file_path = $child_theme_directory . "/atomic-events/" . $relative_file_path;
        if (file_exists($absolute_file_path)) {
            return $absolute_file_path;
        }

        // 2. Load from parent theme override
        $theme_directory = get_template_directory();
        $absolute_file_path = $theme_directory . "/atomic-events/" . $relative_file_path;
        if (file_exists($absolute_file_path)) {
            return $absolute_file_path;
        }

        // 3. Load from child theme selected theme
        $child_theme_directory = get_stylesheet_directory();
        $absolute_file_path = $child_theme_directory . "/atomic-events/themes/" . $selected_theme . "/" . $relative_file_path;
        if (file_exists($absolute_file_path)) {
            return $absolute_file_path;
        }

        // 4. Load from parent theme selected theme
        $theme_directory = get_template_directory();
        $absolute_file_path = $theme_directory . "/atomic-events/themes/" . $selected_theme . "/" . $relative_file_path;
        if (file_exists($absolute_file_path)) {
            return $absolute_file_path;
        }

        // 5. Load from plugin selected theme
        $absolute_file_path = plugin_dir_path(dirname(__FILE__)) . 'templates/themes/' . $selected_theme . '/' . $relative_file_path;
        if (file_exists($absolute_file_path)) {
            return $absolute_file_path;
        }

        // 6. Load from plugin default theme (fallback)
        $absolute_file_path = plugin_dir_path(dirname(__FILE__)) . 'templates/themes/default/' . $relative_file_path;
        if (file_exists($absolute_file_path)) {
            return $absolute_file_path;
        }

        return '';
    }

    /**
     * Load custom single event template following WordPress template hierarchy
     * 
     * Template hierarchy (in order of priority):
     * 1. Child theme: child-theme/atomic-events/single/single-atomic-event.php
     * 2. Parent theme: parent-theme/atomic-events/single/single-atomic-event.php
     * 3. Child theme selected theme: child-theme/atomic-events/themes/{theme}/single/single-atomic-event.php
     * 4. Parent theme selected theme: parent-theme/atomic-events/themes/{theme}/single/single-atomic-event.php
     * 5. Plugin selected theme: plugin/templates/themes/{theme}/single/single-atomic-event.php
     * 6. Plugin default theme: plugin/templates/themes/default/single/single-atomic-event.php
     * 
     * @param string $template The current template path
     * @return string The template path to use
     */
    function load_custom_single_event_template($template) {
        global $post;
        
        // Only apply to atomic-event post type on single pages
        if ($post && $post->post_type == 'atomic-event' && is_single()) {
            $template_path = $this->get_template_path('single/single-atomic-event.php');

            if (!empty($template_path)) {
                return $template_path;
            } else {
                // Fallback to default if custom template not found
                return $template;
            }
        }

        return $template;
    }
}
