<?php
/**
 * Template for displaying single atomic events
 *
 * This template can be overridden by copying it to your theme:
 * - Child theme: child-theme/atomic-events/single/single-atomic-event.php
 * - Parent theme: parent-theme/atomic-events/single/single-atomic-event.php
 *
 * @package Atomic-Events
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

get_header();
?>

<main id="primary" class="site-main">
    <div class="atomic-event-container">
        <?php
        while (have_posts()) :
            the_post();
            
            // Create event model for additional data
            $event_model = new ATMCEVNTS_Event_Model(get_the_ID());
            
            // Load the event content template
            $template_loader = new ATMCEVNTS_Template_Loader;
            $template_loader
                ->set_template_data($event_model, 'event')
                ->get_template_part('content/single', 'event');
        endwhile;
        ?>
    </div>
</main>

<?php
get_footer();
