<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
?>

<div>
    <div class="eventcard eventcard--default max-w-md rounded overflow-hidden shadow-lg bg-white">

        <?php if (!empty($event->get_event_image_id())) : ?>
            <figure class="group relative overflow-hidden">
                <a href="<?php echo esc_url($event->get_permalink()); ?>" class="block">
                    <?php
                    $image = new ATMCEVNTS_Image_Utility($event->get_event_image_id());
                    $image->render_img_tag('full', ['object-cover', 'aspect-video']);
                    ?>
                    <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-20 transition-all duration-300 flex items-center justify-center">
                        <div class="opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                            <i class="ph ph-arrow-right text-white text-2xl"></i>
                        </div>
                    </div>
                </a>
            </figure>
        <?php else : ?>
            <figure class="group relative overflow-hidden">
                <a href="<?php echo esc_url($event->get_permalink()); ?>" class="block">
                    <?php
                    echo '<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 16 9" preserveAspectRatio="xMidYMid meet">
                        <rect width="100%" height="100%" fill="#e0e0e0"/>
                        <text x="50%" y="50%" fill="#9e9e9e" font-size="16" text-anchor="middle" dominant-baseline="middle"></text>
                    </svg>';
                    ?>
                    <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-20 transition-all duration-300 flex items-center justify-center">
                        <div class="opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                            <i class="ph ph-arrow-right text-white text-2xl"></i>
                        </div>
                    </div>
                </a>
            </figure>
        <?php endif; ?>

        <div class="px-6 py-6">
            <div class="eventcard__date icon-text text-sm">
                <i class="ph ph-calendar icon-lg"></i>
                <?php ATMCEVNTS_Date_Utils::atomic_formatted_date($event); ?>
            </div>
            <h3 class="card__title font-bold text-xl mb-2"><?php $event->title(); ?></h3>
            <div class="eventcard__place text-gray-700 text-base">
                <?php if (!empty($event->get_event_venue())) : ?>
                    <div>
                        <?php $event->event_venue(); ?>
                    </div>
                <?php endif; ?>
                <?php if ('US' === $event->get_event_country()) : ?>
                    <?php if (!empty($event->get_event_location_city()) || !empty($event->get_event_location_state())) : ?>
                        <div>
                            <?php
                            $city_state = [];
                            if (!empty($event->get_event_location_city())) {
                                $city_state[] = $event->get_event_location_city();
                            };
                            if (!empty($event->get_event_location_state())) {
                                $city_state[] = $event->get_event_location_state();
                            };
                            ?>
                            <?php
                            echo esc_html(sanitize_text_field(implode(', ', $city_state)));
                            ?>
                        </div>
                    <?php endif; ?>
                <?php else : ?>
                    <div>
                        <?php
                        $city_state = [];
                        if (!empty($event->get_event_location_city())) {
                            $city_state[] = $event->get_event_location_city();
                        };
                        if (!empty($event->get_event_location_region())) {
                            $city_state[] = $event->get_event_location_region();
                        };
                        ?>
                        <?php
                        echo esc_html(sanitize_text_field(implode(', ', $city_state)));
                        ?>
                    </div>

                <?php endif; ?>
                <?php if ($event->get_event_outbound_link()) : ?>
                    <div class="eventcard__link mt-6">
                        <?php
                        ATMCEVNTS_Link::render(
                            $event->get_event_outbound_link(),
                            [
                                'text' => $event->get_event_outbound_link_display_label(),
                                'alt' => $event->get_title(),
                                'class' => 'inline-flex items-center gap-2 rounded-lg bg-blue-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-blue-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-blue-600 transition-colors duration-200 no-underline'
                            ]
                        );
                        ?>
                    </div>
                <?php else : ?>
                    <div class="eventcard__link mt-6">
                        <?php
                        ATMCEVNTS_Link::render(
                            $event->get_permalink(),
                            [
                                'text' => 'More',
                                'alt' => $event->get_title(),
                                'class' => 'inline-flex items-center gap-2 rounded-lg bg-blue-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-blue-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-blue-600 transition-colors duration-200 no-underline'
                            ]
                        );
                        ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>