<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
?>

<article class="atomic-event-single-content event-fade-in">
  <!-- Structured Data for Search Engines -->
  <?php
    $structured_data_service = new ATMCEVNTS_Structured_Data_Service();
    $structured_data_service->print_event_json_ld($event);
  ?>

  <!-- Header -->
  <header class="mx-auto max-w-3xl px-4 sm:px-6 lg:px-8">
    <h1 class="event-title text-3xl font-semibold tracking-tight text-gray-900 dark:text-white sm:text-4xl">
      <?php $event->title(); ?>
    </h1>
  </header>

  <!-- Featured Image -->
  <?php if (!empty($event->get_event_image_id())) : ?>
    <figure class="mx-auto mt-6 max-w-4xl px-4 sm:px-6 lg:px-8">
      <?php
        $image = new ATMCEVNTS_Image_Utility($event->get_event_image_id());
        $image->render_img_tag('full', ['w-full','rounded-2xl','object-cover','shadow-sm','ring-1','ring-black/5','aspect-[16/9]']);
      ?>
             <?php if ($event->has_event_image_caption()) : ?>
                 <figcaption class="mt-3 flex items-start gap-2 text-sm leading-6 text-gray-700 dark:text-gray-300">
          <i class="ph ph-info icon-lg text-gray-500 dark:text-gray-400"></i>
          <span><?php $event->event_image_caption(); ?></span>
        </figcaption>
       <?php endif; ?>
    </figure>
  <?php endif; ?>

     <!-- Event Meta Card -->
   <section class="mx-auto mt-8 max-w-3xl px-4 sm:px-6 lg:px-8">
     <div class="rounded-2xl bg-white/80 p-6 shadow-sm ring-1 ring-black/5 backdrop-blur dark:bg-slate-900/60 dark:ring-white/10 sm:p-8">
       <dl class="space-y-6">
                   <!-- Date -->
          <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 icon-text">
              <i class="ph ph-calendar icon-lg"></i>
              Date
            </dt>
            <dd class="px-0 event-date mt-1 text-base font-semibold text-gray-900 dark:text-white">
              <?php ATMCEVNTS_Date_Utils::atomic_formatted_date($event); ?>
            </dd>
          </div>

          <!-- Venue -->
          <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 icon-text">
              <i class="ph ph-buildings icon-lg"></i>
              Venue
            </dt>
            <dd class="px-0 event-venue mt-1 text-base text-gray-900 dark:text-gray-100">
              <?php if (!empty($event->get_event_venue())) : ?>
                <div><?php $event->event_venue(); ?></div>
              <?php else : ?>
                <div class="text-gray-500 dark:text-gray-400">
                 <?php echo esc_html( $event->get_event_venue() ); ?>
                </div>
              <?php endif; ?>
            </dd>
          </div>

          <!-- Location -->
          <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 icon-text">
              <i class="ph ph-map-pin icon-lg"></i>
              Location
            </dt>
            <dd class="px-0 mt-1 text-base text-gray-900 dark:text-gray-100">
              <?php
                $street_line = [];
                $city_line = [];
                $country_line = [];
                
                // Street line: street address
                if (!empty($event->get_event_street())) {
                  $street_line[] = $event->get_event_street();
                }
                
                // City line: city, state/region, postcode
                if (!empty($event->get_event_location_city())) {
                  $city_line[] = $event->get_event_location_city();
                }
                
                if (!empty($event->get_event_location_region())) {
                  // For US states, extract just the state name (remove "XX - " prefix)
                  $region = $event->get_event_location_region();
                  if ($event->get_event_country() === 'US' && strpos($region, ' - ') !== false) {
                    $region = substr($region, strpos($region, ' - ') + 3);
                  }
                  $city_line[] = $region;
                }
                
                if (!empty($event->get_event_postcode())) {
                  $city_line[] = $event->get_event_postcode();
                }
                
                // Country line: country name
                if (!empty($event->get_event_country())) {
                  $country = $event->get_event_country();
                  // Convert United States of America to USA for display
                  if ($country === 'US') {
                    $country = 'United States of America';
                  }
                  $country_line[] = $country;
                }
                
                if (!empty($street_line) || !empty($city_line) || !empty($country_line)) {
                  if (!empty($street_line)) {
                    echo '<div>' . esc_html( sanitize_text_field( implode(', ', $street_line) ) ) . '</div>';
                  }
                  if (!empty($city_line)) {
                    echo '<div>' . esc_html( sanitize_text_field( implode(', ', $city_line) ) ) . '</div>';
                  }
                  if (!empty($country_line)) {
                    echo '<div>' . esc_html( sanitize_text_field( implode(', ', $country_line) ) ) . '</div>';
                  }
                } else {
                  echo '<span class="text-gray-500 dark:text-gray-400">TBA</span>';
                }
              ?>
            </dd>
                    </div>
        </dl>
      </div>
    </section>

    <!-- Outbound Link -->
    <?php if (!empty($event->get_event_outbound_link())) : ?>
      <section class="mx-auto mt-6 max-w-3xl px-4 sm:px-6 lg:px-8">
        <div class="flex justify-start">
          <a href="<?php echo esc_url($event->get_event_outbound_link()); ?>" 
             target="_blank" 
             rel="noopener noreferrer"
             class="inline-flex items-center gap-2 rounded-lg bg-blue-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-blue-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-blue-600 transition-colors duration-200 no-underline">
            <i class="ph ph-arrow-right icon-md"></i>
            <?php echo esc_html($event->get_event_outbound_link_display_label()); ?>
          </a>
        </div>
      </section>
    <?php endif; ?>

  <!-- Excerpt -->
  <?php if (!empty($event->get_excerpt())) : ?>
    <section class="mx-auto mt-10 max-w-3xl px-4 sm:px-6 lg:px-8">
      <div class="prose prose-slate max-w-none dark:prose-invert">
        <p class="text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
          <?php echo esc_html($event->get_excerpt()); ?>
        </p>
      </div>
    </section>
  <?php endif; ?>

  <!-- Body -->
  <section class="mx-auto mt-10 max-w-3xl px-4 sm:px-6 lg:px-8">
    <div class="prose prose-slate max-w-none dark:prose-invert prose-headings:scroll-mt-24">
      <?php $event->content(); ?>
    </div>
  </section>

  <!-- Tags -->
  <section class="mx-auto mt-8 max-w-3xl px-4 sm:px-6 lg:px-8">
    <?php if (!empty($event->get_event_tags())) : ?>
      <h2 class="mb-3 text-sm font-medium uppercase tracking-wide text-gray-500 dark:text-gray-400">Tags</h2>
      <ul class="flex flex-wrap gap-2 list-none p-0 m-0">
        <?php foreach ($event->get_event_tags() as $tag) : ?>
          <li>
            <span class="inline-flex items-center rounded-full border border-gray-200 bg-gray-50 px-3 py-1 text-sm font-medium text-gray-700 shadow-sm hover:border-gray-300 hover:bg-white dark:border-white/10 dark:bg-slate-800 dark:text-gray-200">
              <?php echo esc_html( $tag->name ); ?>
            </span>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>
  </section>

  <!-- Optional raw dates block (kept off by default) -->
  <div class="hidden">
    <?php if (!empty($event->get_event_start_date())) : ?>
      <div><span class="font-semibold">Start Date:</span> <?php $event->event_start_date(); ?></div>
    <?php endif; ?>
    <?php if (!empty($event->get_event_end_date())) : ?>
      <div><span class="font-semibold">End Date:</span> <?php $event->event_end_date(); ?></div>
    <?php endif; ?>
  </div>
</article>
