<?php
/**
 * Example: How to override the Atomic Events template in your theme
 *
 * To use this template:
 * 1. Copy this file to your theme directory: your-theme/atomic-events/single/single-atomic-event.php
 * 2. Customize the template as needed
 * 3. The plugin will automatically use your theme's version instead of the default
 *
 * Template hierarchy (in order of priority):
 * 1. Child theme: child-theme/atomic-events/single/single-atomic-event.php
 * 2. Parent theme: parent-theme/atomic-events/single/single-atomic-event.php
 * 3. Plugin default: plugin/templates/single/single-atomic-event.php
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

get_header();
?>

<main id="primary" class="site-main">
    <div class="atomic-event-container">
        <?php
        while (have_posts()) :
            the_post();
            
            // Create event model for additional data
            $event_model = new ATMCEVNTS_Event_Model(get_the_ID());
            ?>
            
            <article id="post-<?php the_ID(); ?>" <?php post_class('atomic-event-single'); ?>>
                <header class="entry-header">
                    <h1 class="entry-title"><?php the_title(); ?></h1>
                </header>

                <div class="entry-content">
                    <?php if (!empty($event_model->get_event_start_date())) : ?>
                        <div class="event-date">
                            <strong>Date:</strong> <?php echo esc_html($event_model->get_event_start_date()); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($event_model->get_event_venue())) : ?>
                        <div class="event-venue">
                            <strong>Venue:</strong> <?php echo esc_html($event_model->get_event_venue()); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($event_model->get_event_location_city())) : ?>
                        <div class="event-location">
                            <strong>Location:</strong> <?php echo esc_html($event_model->get_event_location_city()); ?>
                        </div>
                    <?php endif; ?>

                    <div class="event-description">
                        <?php the_content(); ?>
                    </div>
                </div>
            </article>
            
        <?php endwhile; ?>
    </div>
</main>

<?php
get_footer();
?>
