/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    // Plugin templates
    "./templates/**/*.php",
    "./templates/**/*.html",
    "./admin/**/*.php",
    "./public/**/*.php",
    "./includes/**/*.php",
    "./shortcodes/**/*.php",
    "./models/**/*.php",
    "./utils/**/*.php",
    
    // Source files
    "./src/**/*.css",
    "./src/**/*.js",
    "./src/**/*.php",
    
    // WordPress theme overrides (if they exist)
    "../../themes/*/atomic-events/**/*.php",
    "../../themes/*/atomic-events/**/*.html",
    
    // Any other PHP files in the plugin
    "./**/*.php"
  ],
  theme: {
    extend: {
      colors: {
        'atomic': {
          50: '#f0f9ff',
          100: '#e0f2fe',
          200: '#bae6fd',
          300: '#7dd3fc',
          400: '#38bdf8',
          500: '#0ea5e9',
          600: '#0284c7',
          700: '#0369a1',
          800: '#075985',
          900: '#0c4a6e',
        }
      },
      fontFamily: {
        'sans': ['Inter', 'ui-sans-serif', 'system-ui', '-apple-system', 'BlinkMacSystemFont', 'Segoe UI', 'Roboto', 'Helvetica Neue', 'Arial', 'Noto Sans', 'sans-serif'],
      },
      spacing: {
        '18': '4.5rem',
        '88': '22rem',
      }
    },
  },
  plugins: [
    // Add any Tailwind plugins here if needed
  ],
  // Ensure we don't conflict with theme styles
  corePlugins: {
    preflight: false,
  },
}
