<?php
defined('WPINC') or die;
/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://matyus.me
 * @since      1.0.0
 *
 * @package    Atomic_Events
 * @subpackage Atomic_Events/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Atomic_Events
 * @subpackage Atomic_Events/public
 * @author     Lehel Matyus <contact@matyus.me>
 */
class ATMCEVNTS_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Atomic_Events_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Atomic_Events_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		// Load the compiled Tailwind CSS from dist folder
		$tailwind_css_path = plugin_dir_path(__FILE__) . '../dist/css/tailwind.css';
		$tailwind_css_url = plugin_dir_url(__FILE__) . '../dist/css/tailwind.css';
		
		// Check if the compiled CSS exists, otherwise fall back to the old file
		if (file_exists($tailwind_css_path)) {
			wp_enqueue_style($this->plugin_name . "-tailwind", $tailwind_css_url, array(), $this->version, 'all');
		} else {
			// Fallback to the old compiled file
			wp_enqueue_style($this->plugin_name . "-tailwindy", plugin_dir_url(__FILE__) . 'css/tailwindy.css', array(), $this->version, 'all');
		}
		
		// Load any additional custom styles
		wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/atomic-events-public.css', array(), $this->version, 'all');
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Atomic_Events_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Atomic_Events_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/atomic-events-public.js', array('jquery'), $this->version, false);
	}
}
