<?php
defined('WPINC') or die;
/**
 * Fired during plugin activation
 *
 * @link       https://matyus.me
 * @since      1.0.0
 *
 * @package    Atomic_Events
 * @subpackage Atomic_Events/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Atomic_Events
 * @subpackage Atomic_Events/includes
 * @author     Lehel Matyus <contact@matyus.me>
 */
class ATMCEVNTS_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	/**
	 * Plugin activation tasks
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		// Register the post type first
		$post_type = new ATMCEVNTS_Event_Post_Type(ATMCEVNTS_VERSION);
		$post_type->create_event_post_type();
		
		// Flush rewrite rules to ensure event URLs work
		flush_rewrite_rules();
		
		// Add a transient to show activation notice
		set_transient('atomic_events_activated', true, 60);
	}
}
