<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://matyus.me
 * @since             1.0.0
 * @package           Atomic_Events
 *
 * @wordpress-plugin
 * Plugin Name:       Atomic Events Calendar
 * Plugin URI:        https://matyus.me/atomicevents-io
 * Description:       A lightweight WordPress events framework that gives developers and agencies full control without the bloat.
 * Version:           1.0.3
 * Author:            Arpad Lehel Matyus
 * Author URI:        https://matyus.me/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       atomic-events-calendar
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('ATMCEVNTS_VERSION', '1.0.3');
define('ATMCEVNTS_PLUGIN_DIR', plugin_dir_path(__FILE__));


/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-atomic-events-activator.php
 */
function atmcevnts_activate_atomic_events() {
	require_once plugin_dir_path(__FILE__) . 'includes/class-atomic-events-activator.php';
	ATMCEVNTS_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-atomic-events-deactivator.php
 */
function atmcevnts_deactivate_atomic_events() {
	require_once plugin_dir_path(__FILE__) . 'includes/class-atomic-events-deactivator.php';
	ATMCEVNTS_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'atmcevnts_activate_atomic_events');
register_deactivation_hook(__FILE__, 'atmcevnts_deactivate_atomic_events');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-atomic-events.php';

/**
 * Load services
 */
require plugin_dir_path(__FILE__) . 'services/class-structured-data-service.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function atmcevnts_run_atomic_events() {

	$plugin = new ATMCEVNTS_Atomic_Events();
	$plugin->run();
}
atmcevnts_run_atomic_events();
