(function ($) {
	"use strict";

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	// Event post type admin functionality
	$(function() {
		// Function to handle all day event checkbox
		function handleAllDayEvent() {
			var isAllDay = $('#event_all_day').is(':checked');
			var startTimeField = $('#event_start_time');
			var endTimeField = $('#event_end_time');
			var startTimeWrapper = startTimeField.closest('.atmc_admin_date_time_wrapper');
			var endTimeWrapper = endTimeField.closest('.atmc_admin_date_time_wrapper');
			
			if (isAllDay) {
				// Clear time values and hide the time input fields
				startTimeField.val('').prop('readonly', true);
				endTimeField.val('').prop('readonly', true);
				startTimeWrapper.hide();
				endTimeWrapper.hide();
			} else {
				// Show time fields and enable them
				startTimeField.prop('readonly', false);
				endTimeField.prop('readonly', false);
				startTimeWrapper.show();
				endTimeWrapper.show();
			}
		}
		
		// Function to prefill start date and time
		function prefillStartDateTime() {
			var startDateField = $('#event_start_date');
			var startTimeField = $('#event_start_time');
			
			// Only prefill if fields are empty (new event)
			if (!startDateField.val()) {
				// Set today's date in YYYY-MM-DD format
				var today = new Date();
				var year = today.getFullYear();
				var month = String(today.getMonth() + 1).padStart(2, '0');
				var day = String(today.getDate()).padStart(2, '0');
				var todayString = year + '-' + month + '-' + day;
				startDateField.val(todayString);
			}
			
			if (!startTimeField.val()) {
				// Set start time to 8:00 AM
				startTimeField.val('08:00');
			}
		}
		
		// Handle initial state
		handleAllDayEvent();
		prefillStartDateTime();
		
		// Handle checkbox change
		$('#event_all_day').on('change', function() {
			handleAllDayEvent();
		});
	});
})(jQuery);
