<?php
defined('WPINC') or die;
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://matyus.me
 * @since      1.0.0
 *
 * @package    Atomic_Events
 * @subpackage Atomic_Events/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Atomic_Events
 * @subpackage Atomic_Events/admin
 * @author     Lehel Matyus <contact@matyus.me>
 */
class ATMCEVNTS_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Atomic_Events_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Atomic_Events_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/atomic-events-admin.css', array(), $this->version, 'all');
		
		// Enqueue settings page styles
		wp_enqueue_style($this->plugin_name . '-settings', plugin_dir_url(__FILE__) . 'css/atomic-events-settings.css', array(), $this->version, 'all');
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Atomic_Events_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Atomic_Events_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		$screen = get_current_screen();

		// Check if we're on any atomic-event post type page (edit, add new, or list)
		if ('atomic-event' === $screen->post_type) {
			wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/atomic-events-admin.js', array('jquery'), $this->version, false);
			
			// Only add the new event script on edit/add new pages
			if ('post' === $screen->base) {
				wp_enqueue_script($this->plugin_name . "add-new", plugin_dir_url(__FILE__) . 'js/atomic-events-admin-new-event.js', array('jquery'), $this->version, false);
			}
		}
	}

	/**
	 * Display activation notice
	 *
	 * @since    1.0.0
	 */
	public function activation_notice() {
		if (get_transient('atomic_events_activated')) {
			delete_transient('atomic_events_activated');
			?>
			<div class="notice notice-success is-dismissible">
				<p>
					<strong>Atomic Events Calendar</strong> has been activated successfully! 
					You can now create events and use the shortcode <code>[atomic-events]</code> to display them.
					<a href="<?php echo esc_url(admin_url('post-new.php?post_type=atomic-event')); ?>">Create your first event</a>
				</p>
			</div>
			<?php
		}
	}

	/**
	 * Add admin menu for Atomic Events
	 *
	 * @since    1.0.0
	 */
	public function add_admin_menu() {
		add_submenu_page(
			'edit.php?post_type=atomic-event',
			'Atomic Events Calendar Settings',
			'Settings',
			'manage_options',
			'atomic-events-settings',
			array($this, 'admin_settings_page')
		);
	}
/**
 * Admin settings page
 *
 * @since    1.0.0
 */
public function admin_settings_page() {
    // Handle form submission
    $nonce = filter_input(INPUT_POST, '_wpnonce', FILTER_SANITIZE_SPECIAL_CHARS);
    if (filter_input(INPUT_POST, 'flush_rewrite_rules', FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE) && $nonce && wp_verify_nonce(wp_unslash($nonce), 'atomic_events_flush_rules')) {
        			$post_type = new ATMCEVNTS_Event_Post_Type(ATMCEVNTS_VERSION);
        $post_type->flush_event_rewrite_rules();
        echo '<div class="notice notice-success"><p>Rewrite rules have been flushed successfully!</p></div>';
    }

    ?>
    <div class="wrap">
        		<h1><?php esc_html_e('Atomic Events Calendar Settings','atomic-events-calendar'); ?></h1>
        
        <div class="card">
            <h2><?php esc_html_e('Fix 404 Errors','atomic-events-calendar'); ?></h2>
<p><?php esc_html_e('If you\'re experiencing 404 errors when viewing event pages, click the button below to flush rewrite rules:','atomic-events-calendar'); ?></p>
            <form method="post">
                <?php wp_nonce_field('atomic_events_flush_rules'); ?>
                <input type="submit" name="flush_rewrite_rules" class="button button-primary" value="<?php esc_attr_e('Flush Rewrite Rules','atomic-events-calendar'); ?>">
            </form>
        </div>

        <div class="card">
            <h2><?php esc_html_e('Shortcode Usage','atomic-events-calendar'); ?></h2>
<p><?php esc_html_e('Use this shortcode to display events on your pages:','atomic-events-calendar'); ?></p>
            <code>[atomic-events filter="future" max="10" columns="3"]</code>
            <p><strong><?php esc_html_e('Parameters:','atomic-events-calendar'); ?></strong></p>
            <ul>
                <li><code>filter</code>: "future" or "past" (default: "future")</li>
                <li><code>max</code>: <?php esc_html_e('Maximum number of events to display (default: 20)','atomic-events-calendar'); ?></li>
<li><code>columns</code>: <?php esc_html_e('Number of columns (default: 3)','atomic-events-calendar'); ?></li>
<li><code>featured</code>: <?php esc_html_e('Show only featured events (true/false)','atomic-events-calendar'); ?></li>
            </ul>
        </div>
    </div>
    <?php
}
}
