=== Atomic Events Calendar ===
Contributors: lehelm
Donate link: https://matyus.me/
Tags: events, event, calendar
Requires at least: 5.8
Tested up to: 6.8
Requires PHP: 7.4
Stable tag: 1.0.3
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html

Atomic Events Calendar: A lightweight WordPress events framework that gives agencies full control without the bloat.

== Description ==

Atomic Events Calendar is built for developers and agencies who need events in WordPress without the overhead of full event management plugins.  

Instead of starting from scratch on every project, Atomic Events Calendar gives you:  

– A ready-to-use **Events post type**  
– Essential event fields (date, venue, type, etc.)  
– Developer-friendly **shortcodes** to display and filter events  
– A robust **theming structure** for easy overrides and custom designs  

✨ Think of it as a lightweight **framework disguised as a plugin**: everything you need to set up events quickly, with the freedom to extend and customize as you like.  

Perfect for agencies that want full control over their event implementations—without the bloat.  

== Features ==

* **Developer-Friendly** – Clean code structure with services architecture
* **Responsive Design** – Built with Tailwind CSS for modern, responsive layouts
* **Structured Data for Search Engines** – Automatic JSON-LD schema markup for better SEO and rich snippets
* **Custom Post Type** – Dedicated 'atomic-event' post type with all necessary fields
* **Template Override System** – Easy theme integration with template hierarchy
* **Shortcode Support** – Display events anywhere with `[atomic-events]` shortcode
* **Featured Events** – Mark and display featured events prominently
* **Location Management** – Complete address fields (street, city, state, country, postcode)
* **Date & Time Support** – Start/end dates with time support
* **Image Support** – Featured images with captions
* **Member-Only Events** – Restrict events to members only
* **Performance Caching** – Automatic shortcode caching with smart invalidation

Basic usage is through shortcode:

<code>
[atomic-events filter max='10' columns='3' featured='0' 
    skip_first_x='0' skip_first_x_featured='1' order='ASC']
</code>

== Installation ==

1. Upload the Atomic Events Calendar plugin to your blog
1. Activate it
1. Create Event post types
1. Place `[atomic-events]` in your templates


== How can I customize the event template? ==

The plugin provides a default template for single events, but you can override it in your theme:

1. **Child Theme** (recommended): Copy the template to `child-theme/atomic-events/single/single-atomic-event.php`
2. **Parent Theme**: Copy the template to `parent-theme/atomic-events/single/single-atomic-event.php`

The plugin will automatically use your theme's version instead of the default.

See the example template in `templates/theme-override-example.php` for reference.

= My event pages show 404 errors =

If you experience 404 errors when viewing event pages:
1. Go to WordPress Admin <span aria-hidden="true" class="wp-exclude-emoji">→</span> Events <span aria-hidden="true" class="wp-exclude-emoji">→</span> Settings
2. Click "Flush Rewrite Rules"
3. If that doesn't work, go to Settings <span aria-hidden="true" class="wp-exclude-emoji">→</span> Permalinks and click "Save Changes"


=== Template Structure ===

The plugin provides a comprehensive template override system. You can override any template by creating files in your theme:

<pre>
    your-theme/
    └── atomic-events/
    │   ├── cards/
    │   │   ├── card-item-default.php
    │   │   ├── card-item-featured.php
    │   │   ├── card-list-header-default.php
    │   │   └── card-list-footer-default.php
    │   ├── single/
    │   │   └── single-atomic-event.php
    │   ├── content/
    │   │   └── single-event.php
    │   
</pre>


=== Template Hierarchy ===

The plugin follows WordPress template hierarchy for single event pages. Templates are loaded in this order of priority:

1. **Child Theme**: `child-theme/atomic-events/single/single-atomic-event.php`
2. **Parent Theme**: `parent-theme/atomic-events/single/single-atomic-event.php`
3. **Plugin Default**: `plugin/templates/single/single-atomic-event.php`

=== Template Override System ===

The plugin uses a custom template loader that checks for theme templates first, then falls back to the plugin's default template. This ensures:

– **Theme compatibility**: Works with any WordPress theme
– **Customization flexibility**: Easy to override in themes
– **Update safety**: Plugin updates won't break custom templates
– **Developer-friendly**: Clear hierarchy and fallback system

**Template Hierarchy Priority:**

1. **Child Theme**: `child-theme/atomic-events/[template-name].php`
2. **Parent Theme**: `parent-theme/atomic-events/[template-name].php`
3. **Plugin Default**: `plugin/templates/[template-name].php`

**Available Templates:**
– **Shortcode Templates**: Override how events appear in lists and grids
– **Single Event Templates**: Customize individual event page layouts
– **Content Templates**: Modify event content display

The default template includes:
– WordPress header/footer integration
– Event model for accessing custom fields
– Template loader for modular content parts
– Proper WordPress loop structure

=== Custom Fields Available ===

When creating custom templates, you have access to these event fields:

<pre>
$event_model = new AtomicEventModel(get_the_ID());

// Basic event data
$event_model->get_title();
$event_model->get_event_start_date();
$event_model->get_event_end_date();
$event_model->get_event_venue();
$event_model->get_event_location_city();
$event_model->get_event_country();
$event_model->get_event_location_state();
$event_model->get_event_location_region();

// Event settings
$event_model->is_featured();
$event_model->is_member_only();
$event_model->get_event_all_day();

// Additional data
$event_model->get_event_outbound_link();
$event_model->get_event_tag();
$event_model->get_event_image_id();
$event_model->get_permalink();
</pre>

=== Creating Custom Templates ===

1. **Copy the example template** from `templates/theme-override-example.php`
2. **Place it in your theme** at the appropriate path
3. **Customize the template** as needed
4. **Test thoroughly** to ensure proper functionality

=== Hooks and Filters ===

The plugin provides several hooks for customization:

<pre>
// Filter the template path
add_filter('atomic_events_template_path', 'my_custom_template_path', 10, 2);

// Filter event data before display
add_filter('atomic_events_event_data', 'my_custom_event_data', 10, 2);

// Filter whether to show event in lists
add_filter('atomic_events_should_show_in_list', 'my_custom_visibility_logic', 10, 2);
</pre>

=== Shortcode Parameters ===

The `[atomic-events]` shortcode supports these parameters:

– `filter`: "future" or "past" (default: "future")
– `max`: Maximum number of events (default: 20)
– `columns`: Number of columns (default: 3)
– `featured`: Show only featured events (true/false)
– `skip_first_x`: Skip first X events
– `skip_first_x_featured`: Skip first X featured events
– `order`: "ASC" or "DESC" (default: "ASC")

=== Best Practices ===

1. **Always use child themes** for customizations
2. **Test with different themes** to ensure compatibility
3. **Use the event model** for accessing custom fields
4. **Follow WordPress coding standards**
5. **Document custom modifications**
6. **Test thoroughly** before deployment


== Frequently Asked Questions ==

= How can I print out Events =

Simply place a shortcode in your page content area like so:


    [atomic-events filter="future" max="10" columns="3" featured="0" skip_first_x="0" skip_first_x_featured="1" order="ASC"]


== Screenshots ==

1. Event Post type
2. Event List

== Changelog ==

= 1.0.3 =
* Fixed remaining class name references after renaming
* Updated general settings tab with developer-focused information
* Resolved all "Class not found" errors
* Improved plugin stability and compatibility

= 1.0.2 =
* Fixed WordPress.org plugin review naming convention issues
* Updated all class names to use unique ATMCEVNTS_ prefix
* Updated all function names to use unique atmcevnts_ prefix
* Fixed JSON escaping issues in structured data service
* Removed non-permitted files for WordPress.org submission

= 1.0.1 =
* Fixed deprecated FILTER_SANITIZE_STRING usage for PHP 8.1+ compatibility
* Improved input sanitization and validation
* Enhanced security with proper nonce handling
* Fixed WordPress.org plugin checker compliance issues
* Removed hidden files (.DS_Store) for WordPress.org submission
* Added proper escaping for all output
* Improved JSON-LD structured data handling

= 1.0.0 =
* Initial release
* Custom post type for events
* Shortcode support with filtering options
* Template override system
* Structured data (JSON-LD) for SEO
* Featured events functionality
* Member-only events support
* Location management with address fields
* Date and time support with all-day events
* Performance caching system
* Theme integration with template hierarchy
