<?php

if ( ! defined( 'ABSPATH' ) ) exit;

function tg_am_shortcode_atlas_map( $attrs, $content, $tag ) {
  static $div_ids = array();

  $is_admin = in_array( 'administrator', wp_get_current_user()->roles );

  $error = function( $error_id, $data = array() ) use( $tag, $attrs, $is_admin ) {
    if ( $is_admin ) {
      require_once TG_AM_ROOT_DIR . '/admin/errors.php';
      return tg_am_render_shortcode_error( $tag, $attrs, $error_id, $data );
    }

    return '';
  };

  $post_id =
    count( $attrs ) > 0 && preg_match( '/^\d+$/', $first_attr = trim( $attrs[0] ) )
      ? intval( $first_attr )
      : null;

  if ( empty( $post_id ) ) {
    return $error( 'expected_map_id' );
  }

  $query = new WP_Query( array(
    'p' => $post_id,
    'post_type' => 'tg_am_map',
    'post_status' => 'publish',
    'posts_per_page' => 1,
  ) );

  $posts = $query->get_posts();
  $post = empty( $posts ) ? null : $posts[0];

  if ( empty( $post ) ) {
    return $error( 'map_not_found', array( 'id' => $post_id ) );
  }

  $meta = get_post_meta( $post_id, TG_AM_META_MAP, true );
  if ( ! is_array( $meta ) || empty( $meta['code'] ) ) {
    return $error( 'map_load_error', array( 'id' => $post_id ) );
  }

  $map_code = $meta['code'];

  $theme_id = empty( $meta['themeId'] )
    ? TG_AM_DEFAULT_MAP_THEME_ID
    : $meta['themeId'];

  $get_bool = function( $key ) use( $meta ) {
    return empty( $meta[$key] ) ? null : $meta[$key] === 'true';
  };

  ob_start();

  do_action( 'tg_am_shortcode_atlas_map', $meta, $post_id, $theme_id );

  $props = array(
    'mapId' => $post_id,
    'mapCode' => $map_code,
    'themeId' => $theme_id,
    'hasTooltips' => $get_bool( 'hasTooltips' ),
    'hasActions' => $get_bool( 'hasActions' ),
    'hasHoverEffects' => $get_bool( 'hasHoverEffects' ),
    'hasUsStateLabels' => $get_bool( 'hasUsStateLabels' ),
    'usStateLabelSizePixels' => empty( $meta['usStateLabelSizePixels'] )
      ? null
      : $meta['usStateLabelSizePixels']
  );

  $props = apply_filters( 'tg_am_shortcode_atlas_map_props', $props, $meta );

  if ( ! empty( $meta['data'] ) && is_array( $meta['data'] ) ) {
    $data = $meta['data'];

    if ( ! empty( $data['__default'] ) && is_array( $data['__default'] ) ) {
      $props['__default'] = $data['__default'];
    }

    if ( ! empty( $data[$map_code] ) && is_array( $data[$map_code] ) ) {
      $props['mapData'] = $data[$map_code];
    }
  }

  $div_id = 'tg_am_map_' . str_replace( '-', '_', $map_code );
  if ( empty( $div_ids[$div_id] ) ) {
    $div_ids[$div_id] = 1;
  } else {
    $div_id .= '_' . ( ++$div_ids[$div_id] );
  }

?>
  <p
    id="<?php echo esc_attr( $div_id ) ?>"
    data-tg-am-props="<?php echo esc_attr( wp_json_encode( $props ) ) ?>"
  ></p>
<?php

  return ob_get_clean();
}
