<?php

/**
 * Plugin Name:       Interactive World, Europe & US Maps - Atlas Maps
 * Description:       Build interactive world, Europe & US maps with clickable regions, tooltips and pins. Responsive map plugin for WordPress, no coding required.
 * Version:           1.0.3
 * Author:            Toro Guapo
 * Author URI:        https://toroguapo.com/
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       atlas-maps
 * Requires at least: 6.5
 * Requires PHP:      7.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( defined( 'TG_AM' ) ) {
  register_activation_hook( __FILE__, function() {
    deactivate_plugins( plugin_basename( __FILE__ ) );
    wp_die(
      'Another Atlas Maps instance has already been activated. '.
      'Please activate only one Atlas Maps at a time.',
      'Atlas Maps already activated',
      array(
        'link_text' => '&larr; Back to plugins',
        'link_url' => '/wp-admin/plugins.php'
      )
    );
  } );
  return;
}

define( 'TG_AM_ROOT_DIR', plugin_dir_path( __FILE__ ) );
define( 'TG_AM_ROOT_URL', plugin_dir_url( __FILE__ ) );

define( 'TG_AM_ASSETS_DIR', TG_AM_ROOT_DIR . 'assets/' );
define( 'TG_AM_ASSETS_URL', TG_AM_ROOT_URL . 'assets/' );

define( 'TG_AM_PLUGIN_FILE', __FILE__ );

define( 'TG_AM', 'Essential' );

define( 'TG_AM_SHORTCODE_MAP', 'atlas-map' );
define( 'TG_AM_META_MAP', '_tg_am_map' );
define( 'TG_AM_DEFAULT_MAP_CODE', 'us' );
define( 'TG_AM_DEFAULT_MAP_THEME_ID', 'neutral' );

if ( is_admin() ) {
  require_once __DIR__ . '/admin/index.php';
} else {
  require_once __DIR__ . '/frontend/index.php';
}

$tg_am_assets_dir = strtolower( TG_AM );

define( 'TG_AM_EDITION_ASSETS_DIR', TG_AM_ASSETS_DIR . $tg_am_assets_dir );
define( 'TG_AM_EDITION_ASSETS_URL', TG_AM_ASSETS_URL . $tg_am_assets_dir );

require_once TG_AM_EDITION_ASSETS_DIR . '/index.php';

if ( function_exists( 'tg_am_asset_style_css' ) ) {
  function tg_am_enqueue() {
    wp_enqueue_style(
      /* handle */ 'tg_am_asset_style_css',
      /* src    */ call_user_func( 'tg_am_asset_style_css' ),
      /* deps   */ array(),
      /* ver    */ tg_am_asset_style_version()
    );
  }

  add_action( 'wp_enqueue_scripts', 'tg_am_enqueue' );
  add_action( 'admin_enqueue_scripts', 'tg_am_enqueue' );
}
